/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.rendition;

import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.VideoDocument;

public class VideoRenditionProvider
implements RenditionProvider {
    public boolean isAvailable(DocumentModel doc, RenditionDefinition definition) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDocument == null) {
            return false;
        }
        TranscodedVideo transcodedVideo = videoDocument.getTranscodedVideo(definition.getName());
        return transcodedVideo != null && transcodedVideo.getBlob() != null;
    }

    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) throws RenditionException {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDocument == null) {
            return Collections.emptyList();
        }
        TranscodedVideo transcodedVideo = videoDocument.getTranscodedVideo(definition.getName());
        if (transcodedVideo != null) {
            return Collections.singletonList(transcodedVideo.getBlob());
        }
        return Collections.emptyList();
    }
}

