/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.runtime.api.Framework;

public class AnnotationsFulltextInjector {
    public static final String RELATED_TEXT_PROPERTY = "relatedtext";
    public static final String RELATED_TEXT_ID_PROPERTY = "relatedtextid";
    public static final String RELATED_TEXT_LIST_PROPERTY = "relatedtext:relatedtextresources";
    public static final String ANNOTATION_RESOURCE_ID_PREFIX = "annotation_";

    public boolean removeAnnotationText(DocumentModel doc, String annotationId) throws ClientException {
        List relatedResources = (List)doc.getProperty(RELATED_TEXT_LIST_PROPERTY).getValue(List.class);
        String resourceIdToRemove = annotationId == null ? null : AnnotationsFulltextInjector.makeResourceId(annotationId);
        ArrayList<Map> resourcesToRemove = new ArrayList<Map>();
        for (Map resource : relatedResources) {
            String resourceId = (String)resource.get(RELATED_TEXT_ID_PROPERTY);
            if (resourceIdToRemove != null) {
                if (!resourceIdToRemove.equals(resourceId)) continue;
                resourcesToRemove.add(resource);
                continue;
            }
            if (resourceId != null && !resourceId.startsWith(ANNOTATION_RESOURCE_ID_PREFIX)) continue;
            resourcesToRemove.add(resource);
        }
        if (!resourcesToRemove.isEmpty()) {
            relatedResources.removeAll(resourcesToRemove);
            doc.setPropertyValue(RELATED_TEXT_LIST_PROPERTY, (Serializable)((Object)relatedResources));
            return true;
        }
        return false;
    }

    public void setAnnotationText(DocumentModel doc, String annotationId, String annotationBody) throws ClientException {
        if (annotationBody == null) {
            return;
        }
        SimpleBlobHolder bh = new SimpleBlobHolder(Blobs.createBlob((String)annotationBody, (String)"text/html"));
        ConversionService service = (ConversionService)Framework.getService(ConversionService.class);
        if (service != null) {
            try {
                annotationBody = service.convert("html2text", (BlobHolder)bh, null).getBlob().getString();
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
        }
        List relatedResources = (List)doc.getProperty(RELATED_TEXT_LIST_PROPERTY).getValue(List.class);
        HashMap<String, String> resource = new HashMap<String, String>();
        resource.put(RELATED_TEXT_ID_PROPERTY, AnnotationsFulltextInjector.makeResourceId(annotationId));
        resource.put(RELATED_TEXT_PROPERTY, annotationBody);
        relatedResources.add(resource);
        doc.setPropertyValue(RELATED_TEXT_LIST_PROPERTY, (Serializable)((Object)relatedResources));
    }

    protected static String makeResourceId(String annotationId) {
        return ANNOTATION_RESOURCE_ID_PREFIX + annotationId;
    }
}

