/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gimp.tiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilesImpl;
import org.nuxeo.ecm.platform.pictures.tiles.gimp.GimpExecutor;
import org.nuxeo.ecm.platform.pictures.tiles.tilers.BasePictureTiler;

public class GimpTiler
extends BasePictureTiler {
    @Override
    public String getName() {
        return "GimpTiler";
    }

    @Override
    public boolean needsSync() {
        return true;
    }

    @Override
    public PictureTiles getTilesFromFile(ImageInfo input, String outputDirPath, int tileWidth, int tileHeight, int maxTiles, int xCenter, int yCenter, long lastModificationTime, boolean fullGeneration) throws ClientException {
        String inputFilePath = input.getFilePath();
        if (fullGeneration) {
            xCenter = -1;
            yCenter = -1;
        }
        Map<String, String> result = null;
        if (!outputDirPath.endsWith("/")) {
            outputDirPath = outputDirPath + "/";
        }
        try {
            result = this.exec("python-fu-nx-tiles", inputFilePath, outputDirPath, tileWidth, tileHeight, maxTiles, xCenter, yCenter);
        }
        catch (IOException e) {
            throw new ClientException("Error while calling gimp command line", (Throwable)e);
        }
        result.put(PictureTilesImpl.TILE_INPUT_FILE_KEY, inputFilePath);
        result.put(PictureTilesImpl.TILES_WIDTH_KEY, Integer.toString(tileWidth));
        result.put(PictureTilesImpl.TILES_HEIGHT_KEY, Integer.toString(tileHeight));
        result.put(PictureTilesImpl.MAX_TILES_KEY, Integer.toString(maxTiles));
        result.put(PictureTilesImpl.TILE_OUTPUT_DIR_KEY, outputDirPath);
        result.put(PictureTilesImpl.TILES_PREFIX_KEY, "tile");
        result.put(PictureTilesImpl.TILES_SUFFIX_KEY, ".jpg");
        result.put(PictureTilesImpl.PROGRESSIVE_TILING_KEY, Boolean.toString(!fullGeneration));
        PictureTilesImpl tiles = null;
        tiles = new PictureTilesImpl(result);
        return tiles;
    }

    protected Map<String, String> exec(String procName, String inputFilePath, String outputPath, int tileX, int tileY, int nbTiles, int centerXTile, int centerYTile) throws IOException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(inputFilePath);
        params.add(new Integer(tileX));
        params.add(new Integer(tileY));
        params.add(new Integer(nbTiles));
        params.add(outputPath);
        params.add(new Integer(centerXTile));
        params.add(new Integer(centerYTile));
        return GimpExecutor.exec(procName, params);
    }
}

