/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.operation;

import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

@Operation(id="Picture.Resize", category="Conversion", label="Resize a picture", description="Use conversion service to resize a picture contained in a Document or a Blob", aliases={"Picture.resize"})
public class PictureResize {
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String PICTURE_RESIZE_CONVERTER = "pictureResize";
    public static final String ID = "Picture.Resize";
    @Param(name="maxWidth", required=true)
    protected int maxWidth = 0;
    @Param(name="maxHeight", required=true)
    protected int maxHeigh = 0;
    @Context
    protected ConversionService service;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        Blob pictureBlob = null;
        MultiviewPicture mvp = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class);
        if (mvp != null) {
            pictureBlob = mvp.getView(mvp.getOrigin()).getBlob();
        } else {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null) {
                pictureBlob = bh.getBlob();
            }
        }
        if (pictureBlob == null) {
            Blob blob = Blobs.createBlob((String)"Unable to find a picture in the Document");
            blob.setFilename(doc.getName() + ".null");
            return blob;
        }
        return this.run(pictureBlob);
    }

    @OperationMethod
    public Blob run(Blob blob) {
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put(WIDTH, this.maxWidth);
        parameters.put(HEIGHT, this.maxHeigh);
        if (!this.service.isConverterAvailable(PICTURE_RESIZE_CONVERTER).isAvailable()) {
            return blob;
        }
        BlobHolder result = this.service.convert(PICTURE_RESIZE_CONVERTER, (BlobHolder)bh, parameters);
        if (result != null) {
            return result.getBlob();
        }
        return Blobs.createBlob((String)"Converter did not return any result");
    }
}

