/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;

public class VideoConversionWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoConversionWork.class);
    public static final String CATEGORY_VIDEO_CONVERSION = "videoConversion";
    public static final String VIDEO_CONVERSIONS_DONE_EVENT = "videoConversionsDone";
    protected final String conversionName;

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ':' + docId + ":videoconv:";
    }

    public VideoConversionWork(String repositoryName, String docId, String conversionName) {
        super(VideoConversionWork.computeIdPrefix(repositoryName, docId) + conversionName);
        this.setDocument(repositoryName, docId);
        this.conversionName = conversionName;
    }

    public String getCategory() {
        return CATEGORY_VIDEO_CONVERSION;
    }

    public String getTitle() {
        return "Video Conversion " + this.conversionName;
    }

    public void work() {
        this.setStatus("Extracting");
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        Video originalVideo = null;
        try {
            this.initSession();
            originalVideo = this.getVideoToConvert();
            this.commitOrRollbackTransaction();
        }
        finally {
            this.cleanUp(true, null);
        }
        if (originalVideo == null) {
            this.setStatus("Nothing to process");
            return;
        }
        VideoService service = (VideoService)Framework.getLocalService(VideoService.class);
        this.setStatus("Transcoding");
        TranscodedVideo transcodedVideo = service.convert(originalVideo, this.conversionName);
        this.startTransaction();
        this.setStatus("Saving");
        this.initSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        this.saveNewTranscodedVideo(doc, transcodedVideo);
        this.fireVideoConversionsDoneEvent(doc);
        this.setStatus("Done");
    }

    protected Video getVideoToConvert() {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        Video video = videoDocument.getVideo();
        if (video == null) {
            log.warn((Object)("No original video to transcode for: " + doc));
        }
        return video;
    }

    protected void saveNewTranscodedVideo(DocumentModel doc, TranscodedVideo transcodedVideo) {
        ArrayList<Map> transcodedVideos = (ArrayList<Map>)doc.getPropertyValue("vid:transcodedVideos");
        if (transcodedVideos == null) {
            transcodedVideos = new ArrayList<Map>();
        }
        transcodedVideos.add(transcodedVideo.toMap());
        doc.setPropertyValue("vid:transcodedVideos", (Serializable)transcodedVideos);
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(doc);
    }

    protected void fireVideoConversionsDoneEvent(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        List workIds = workManager.listWorkIds(CATEGORY_VIDEO_CONVERSION, null);
        String idPrefix = VideoConversionWork.computeIdPrefix(this.repositoryName, this.docId);
        int worksCount = 0;
        for (String workId : workIds) {
            if (!workId.startsWith(idPrefix) || ++worksCount <= 1) continue;
            return;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(VIDEO_CONVERSIONS_DONE_EVENT);
        ((EventService)Framework.getLocalService(EventService.class)).fireEvent(event);
    }
}

