/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.EventListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.PreviewSettings;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.listener.AnnotatedEventListener;

public class AnnotationFrameApplication {
    private static WebConfiguration WEB_CONFIGURATION;
    private static AnnotationController controller;
    private static AnnotatedEventListener annotatedEventListener;

    public static AnnotationController getController() {
        return controller;
    }

    public static AnnotatedEventListener getMainEventListener() {
        return annotatedEventListener;
    }

    public static void build(WebConfiguration webConfiguration) {
        WEB_CONFIGURATION = webConfiguration;
        AnnotationFrameApplication.buildApplication();
    }

    private static void buildApplication() {
        controller = new AnnotationController(WEB_CONFIGURATION, true);
        annotatedEventListener = new AnnotatedEventListener(controller);
        AnnotationFrameApplication.configureController();
        AnnotationFrameApplication.setListeners();
        controller.loadAnnotations();
        AnnotationFrameApplication.notifyFrameModuleInitialized();
    }

    private static native void notifyFrameModuleInitialized();

    private static void configureController() {
        PreviewSettings previewSettings = PreviewSettings.getInstance();
        Log.debug((String)("previewSettings = " + previewSettings));
        if (previewSettings != null) {
            controller.setImageOnly(previewSettings.isImageOnly());
            controller.setMultiImage(previewSettings.isMultiImageAnnotation());
            controller.setXPointerFilter(previewSettings.getXPointerFilterPath());
            controller.setPointerAdapter(previewSettings.getPointerAdapter());
            controller.setAnnotationDecoratorFunction(previewSettings.getAnnotationDecoratorFunction());
        }
        Document.get().getBody().setScrollTop(controller.getFrameScrollFromTop());
    }

    private static void setListeners() {
        DOM.sinkEvents((com.google.gwt.dom.client.Element)((Element)Document.get().cast()), (int)77);
        DOM.setEventListener((com.google.gwt.dom.client.Element)((Element)Document.get().cast()), (EventListener)annotatedEventListener);
    }
}

