/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.Mp4NotMetaFieldKey;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4NonStandardFieldKey;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.field.Mp4DiscNoField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4GenreField;
import org.jaudiotagger.tag.mp4.field.Mp4TagBinaryField;
import org.jaudiotagger.tag.mp4.field.Mp4TagByteField;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.jaudiotagger.tag.mp4.field.Mp4TagRawBinaryField;
import org.jaudiotagger.tag.mp4.field.Mp4TagReverseDnsField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.mp4.field.Mp4TrackField;

public class Mp4TagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");

    public Mp4Tag read(RandomAccessFile raf) throws CannotReadException, IOException {
        Mp4MetaBox meta;
        Mp4Tag tag = new Mp4Tag();
        Mp4BoxHeader moovHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.MOOV.getFieldName());
        if (moovHeader == null) {
            throw new CannotReadException(ErrorMessage.MP4_FILE_NOT_CONTAINER.getMsg());
        }
        ByteBuffer moovBuffer = ByteBuffer.allocate(moovHeader.getLength() - 8);
        raf.getChannel().read(moovBuffer);
        moovBuffer.rewind();
        Mp4BoxHeader boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.UDTA.getFieldName());
        if (boxHeader != null) {
            boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.META.getFieldName());
            if (boxHeader == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return tag;
            }
            meta = new Mp4MetaBox(boxHeader, moovBuffer);
            meta.processData();
            boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.ILST.getFieldName());
            if (boxHeader == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return tag;
            }
        } else {
            boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.META.getFieldName());
            if (boxHeader == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return tag;
            }
            meta = new Mp4MetaBox(boxHeader, moovBuffer);
            meta.processData();
            boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.ILST.getFieldName());
            if (boxHeader == null) {
                logger.warning(ErrorMessage.MP4_FILE_HAS_NO_METADATA.getMsg());
                return tag;
            }
        }
        int length = boxHeader.getLength() - 8;
        ByteBuffer metadataBuffer = moovBuffer.slice();
        logger.info("headerlengthsays:" + length + "datalength:" + metadataBuffer.limit());
        logger.info("Started to read metadata fields at position is in metadata buffer:" + metadataBuffer.position());
        for (int read = 0; read < length; read += boxHeader.getLength()) {
            boxHeader.update(metadataBuffer);
            logger.info("Next position is at:" + metadataBuffer.position());
            this.createMp4Field(tag, boxHeader, metadataBuffer.slice());
            metadataBuffer.position(metadataBuffer.position() + boxHeader.getDataLength());
        }
        return tag;
    }

    private void createMp4Field(Mp4Tag tag, Mp4BoxHeader header, ByteBuffer raw) throws UnsupportedEncodingException {
        if (header.getId().equals("----")) {
            try {
                Mp4TagReverseDnsField field = new Mp4TagReverseDnsField(header, raw);
                tag.addField(field);
            }
            catch (Exception e) {
                logger.warning(ErrorMessage.MP4_UNABLE_READ_REVERSE_DNS_FIELD.getMsg(e.getMessage()));
                Mp4TagRawBinaryField field = new Mp4TagRawBinaryField(header, raw);
                tag.addField(field);
            }
        } else {
            int currentPos = raw.position();
            boolean isDataIdentifier = Utils.getString(raw, 4, 4, "ISO-8859-1").equals("data");
            raw.position(currentPos);
            if (isDataIdentifier) {
                int type = Utils.getIntBE(raw, 9, 11);
                Mp4FieldType fieldType = Mp4FieldType.getFieldType(type);
                logger.info("Box Type id:" + header.getId() + ":type:" + (Object)((Object)fieldType));
                if (header.getId().equals(Mp4FieldKey.TRACK.getFieldName())) {
                    Mp4TrackField field = new Mp4TrackField(header.getId(), raw);
                    tag.addField(field);
                } else if (header.getId().equals(Mp4FieldKey.DISCNUMBER.getFieldName())) {
                    Mp4DiscNoField field = new Mp4DiscNoField(header.getId(), raw);
                    tag.addField(field);
                } else if (header.getId().equals(Mp4FieldKey.GENRE.getFieldName())) {
                    Mp4GenreField field = new Mp4GenreField(header.getId(), raw);
                    tag.addField(field);
                } else if (header.getId().equals(Mp4FieldKey.ARTWORK.getFieldName()) || Mp4FieldType.isCoverArtType(fieldType)) {
                    int processedDataSize = 0;
                    int imageCount = 0;
                    while (processedDataSize < header.getDataLength()) {
                        if (imageCount > 0) {
                            type = Utils.getIntBE(raw, processedDataSize + 9, processedDataSize + 9 + 3 - 1);
                            fieldType = Mp4FieldType.getFieldType(type);
                        }
                        Mp4TagCoverField field = new Mp4TagCoverField(raw, fieldType);
                        tag.addField(field);
                        processedDataSize += field.getDataAndHeaderSize();
                        ++imageCount;
                    }
                } else if (fieldType == Mp4FieldType.TEXT) {
                    Mp4TagTextField field = new Mp4TagTextField(header.getId(), raw);
                    tag.addField(field);
                } else if (fieldType == Mp4FieldType.IMPLICIT) {
                    Mp4TagTextNumberField field = new Mp4TagTextNumberField(header.getId(), raw);
                    tag.addField(field);
                } else if (fieldType == Mp4FieldType.INTEGER) {
                    Mp4TagByteField field = new Mp4TagByteField(header.getId(), raw);
                    tag.addField(field);
                } else {
                    boolean existingId = false;
                    for (Mp4FieldKey key : Mp4FieldKey.values()) {
                        if (!key.getFieldName().equals(header.getId())) continue;
                        existingId = true;
                        logger.warning("Known Field:" + header.getId() + " with invalid field type of:" + type + " is ignored");
                        break;
                    }
                    if (!existingId) {
                        logger.warning("UnKnown Field:" + header.getId() + " with invalid field type of:" + type + " created as binary");
                        Mp4TagBinaryField field = new Mp4TagBinaryField(header.getId(), raw);
                        tag.addField(field);
                    }
                }
            } else if (header.getId().equals(Mp4NonStandardFieldKey.AAPR.getFieldName())) {
                Mp4TagRawBinaryField field = new Mp4TagRawBinaryField(header, raw);
                tag.addField(field);
            } else {
                Mp4TagRawBinaryField field = new Mp4TagRawBinaryField(header, raw);
                tag.addField(field);
            }
        }
    }
}

