/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.adapter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.DocumentImageResource;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.ImageResource;
import org.nuxeo.runtime.api.Framework;

public class PictureTilesAdapterImpl
implements PictureTilesAdapter {
    protected String xPath;
    protected DocumentModel doc;
    protected String fileName;
    protected Map<String, PictureTiles> tiles = new ConcurrentHashMap<String, PictureTiles>();
    protected static PictureTilingService pts;
    protected static final Log log;

    public PictureTilesAdapterImpl(DocumentModel doc, String xPath) {
        this.xPath = xPath;
        this.doc = doc;
    }

    public PictureTilesAdapterImpl(DocumentModel doc) {
        this(doc, null);
    }

    protected ImageResource getResource() {
        DocumentImageResource res = new DocumentImageResource(this.doc, this.xPath);
        if (this.fileName != null) {
            res.setFileName(this.fileName);
        }
        return res;
    }

    protected PictureTilingService getService() {
        if (pts == null) {
            pts = (PictureTilingService)Framework.getLocalService(PictureTilingService.class);
        }
        return pts;
    }

    @Override
    public PictureTiles getTiles(int tileWidth, int tileHeight, int maxTiles) {
        String key = tileWidth + "-" + tileHeight + "-" + maxTiles;
        if (!this.tiles.containsKey(key)) {
            PictureTiles tile = this.getService().getTiles(this.getResource(), tileWidth, tileHeight, maxTiles, 0, 0, false);
            this.tiles.put(key, tile);
        }
        return this.tiles.get(key);
    }

    @Override
    public void cleanup() {
        if (this.tiles == null) {
            return;
        }
        for (String k : this.tiles.keySet()) {
            this.tiles.get(k).release();
        }
        this.tiles = new ConcurrentHashMap<String, PictureTiles>();
    }

    public String getXPath() {
        return this.xPath;
    }

    @Override
    public void setXPath(String path) {
        this.xPath = path;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    @Override
    public void setDoc(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    static {
        log = LogFactory.getLog(PictureTilesAdapterImpl.class);
    }
}

