/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PictureMigrationHandler
extends RepositoryInitializationHandler {
    private static final Log log = LogFactory.getLog(PictureMigrationHandler.class);
    public static final String PICTURES_TO_MIGRATE_QUERY = "SELECT ecm:uuid FROM Document WHERE ecm:mixinType = 'Picture' AND ecm:isProxy = 0 AND views/*/title = 'Original' AND content/data IS NULL";
    public static final String ORIGINAL_VIEW_TITLE = "Original";
    public static final String FILE_CONTENT_PROPERTY = "file:content";
    public static final String FILE_FILENAME_PROPERTY = "file:filename";
    public static final int BATCH_SIZE = 50;
    public static final String DISABLE_QUOTA_CHECK_LISTENER = "disableQuotaListener";

    public void doInitializeRepository(CoreSession session) {
        boolean txStarted = false;
        if (!TransactionHelper.isTransactionActive()) {
            txStarted = true;
        }
        try {
            this.doMigration(session);
        }
        finally {
            if (txStarted) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMigration(CoreSession session) {
        Set<String> pictureIds = this.getPictureIdsToMigrate(session);
        if (pictureIds.isEmpty()) {
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("Started migration of %d documents with the 'Picture' facet", pictureIds.size()));
        }
        long pictureMigratedCount = 0L;
        try {
            for (String pictureId : pictureIds) {
                if (!this.migratePicture(session, pictureId) || ++pictureMigratedCount % 50L != 0L) continue;
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("Finished migration of %d/%d documents with the 'Picture' facet", pictureMigratedCount, pictureIds.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getPictureIdsToMigrate(CoreSession session) {
        HashSet<String> pictureIds = new HashSet<String>();
        try (IterableQueryResult it = null;){
            it = session.queryAndFetch(PICTURES_TO_MIGRATE_QUERY, "NXQL", new Object[0]);
            for (Map map : it) {
                String id = (String)map.get("ecm:uuid");
                if (id == null) continue;
                pictureIds.add(id);
            }
        }
        return pictureIds;
    }

    protected boolean migratePicture(CoreSession session, String docId) {
        MultiviewPicture multiviewPicture;
        PictureView originalView;
        Blob blob;
        DocumentModel picture = session.getDocument((DocumentRef)new IdRef(docId));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Migrating %s", picture));
        }
        if ((blob = (originalView = (multiviewPicture = (MultiviewPicture)picture.getAdapter(MultiviewPicture.class)).getView(ORIGINAL_VIEW_TITLE)).getBlob()) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("No Original view Blob found for %s", picture));
            }
            return false;
        }
        String filename = blob.getFilename();
        filename = StringUtils.defaultString((String)filename).replaceAll("^Original_", "");
        blob.setFilename(filename);
        picture.setPropertyValue(FILE_CONTENT_PROPERTY, (Serializable)blob);
        picture.setPropertyValue(FILE_FILENAME_PROPERTY, (Serializable)((Object)filename));
        multiviewPicture.removeView(ORIGINAL_VIEW_TITLE);
        if (picture.isVersion()) {
            picture.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        picture.putContextData(DISABLE_QUOTA_CHECK_LISTENER, (Serializable)Boolean.TRUE);
        session.saveDocument(picture);
        return true;
    }
}

