/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.listener;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.VideoHelper;

public class VideoStoryboardListener
implements PostCommitFilteringEventListener {
    public static final Log log = LogFactory.getLog(VideoStoryboardListener.class);

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            if (!"videoChanged".equals(event.getName())) continue;
            this.handleEvent(event);
        }
    }

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("HasStoryboard")) {
            BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
            VideoHelper.updateStoryboard(doc, blobHolder.getBlob());
            try {
                VideoHelper.updatePreviews(doc, blobHolder.getBlob());
            }
            catch (IOException e) {
                log.error((Object)String.format("Failed to extract previews for video '%s': %s", doc.getTitle(), e.getMessage()), (Throwable)e);
            }
            CoreSession session = docCtx.getCoreSession();
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            session.saveDocument(doc);
            session.save();
        }
    }

    public boolean acceptEvent(Event event) {
        return "videoChanged".equals(event.getName());
    }
}

