/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.validation.client.DefaultTraversableResolver;
import com.google.gwt.validation.client.spi.GwtConfigurationState;
import com.google.gwt.validation.client.spi.GwtValidationProvider;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;

public abstract class BaseGwtConfiguration
implements Configuration<BaseGwtConfiguration> {
    protected final GwtValidationProvider provider;
    protected final BootstrapState state;
    protected final Map<String, String> properties = new HashMap<String, String>();
    protected ConstraintValidatorFactory constraintValidatorFactory;
    protected MessageInterpolator messageInterpolator;
    protected TraversableResolver traversableResolver;

    public BaseGwtConfiguration(GwtValidationProvider gwtValidationProvider, BootstrapState state) {
        this.provider = gwtValidationProvider;
        this.state = state;
    }

    public final BaseGwtConfiguration addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public final ValidatorFactory buildValidatorFactory() {
        GwtConfigurationState configurationState = new GwtConfigurationState(this.constraintValidatorFactory, this.messageInterpolator, this.properties, this.traversableResolver);
        return this.provider.buildValidatorFactory(configurationState);
    }

    public final BaseGwtConfiguration constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public final ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return (ConstraintValidatorFactory)GWT.create(ConstraintValidatorFactory.class);
    }

    public final MessageInterpolator getDefaultMessageInterpolator() {
        return (MessageInterpolator)GWT.create(MessageInterpolator.class);
    }

    public final TraversableResolver getDefaultTraversableResolver() {
        return new DefaultTraversableResolver();
    }

    public final BaseGwtConfiguration ignoreXmlConfiguration() {
        return this;
    }

    public final BaseGwtConfiguration messageInterpolator(MessageInterpolator interpolator) {
        this.messageInterpolator = interpolator;
        return this;
    }

    public final BaseGwtConfiguration traversableResolver(TraversableResolver resolver) {
        this.traversableResolver = resolver;
        return this;
    }
}

