/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.storyboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.video.storyboard.StoryboardItem;

@Name(value="storyboardActions")
@Scope(value=ScopeType.EVENT)
public class StoryboardActions {
    public List<StoryboardItem> getItems(DocumentModel doc) throws PropertyException {
        if (!doc.hasFacet("HasStoryboard")) {
            return Collections.emptyList();
        }
        int size = ((List)doc.getProperty("vid:storyboard").getValue(List.class)).size();
        ArrayList<StoryboardItem> items = new ArrayList<StoryboardItem>(size);
        for (int i = 0; i < size; ++i) {
            items.add(new StoryboardItem(doc, "vid:storyboard", i));
        }
        return items;
    }

    public String getStoryboardItemsAsJsonSettings(DocumentModel doc) throws PropertyException {
        List<StoryboardItem> items = this.getItems(doc);
        ObjectMapper o = new ObjectMapper();
        ObjectNode settings = o.createObjectNode();
        for (StoryboardItem storyboardItem : items) {
            ObjectNode thumb = o.createObjectNode();
            thumb.put("src", storyboardItem.getUrl());
            settings.put(storyboardItem.getTimecode().split("\\.")[0], (JsonNode)thumb);
        }
        return settings.toString();
    }
}

