/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageConverter;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilesImpl;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.BlobResource;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.ImageResource;
import org.nuxeo.ecm.platform.pictures.tiles.magick.tiler.MagickTiler;
import org.nuxeo.ecm.platform.pictures.tiles.service.GCTask;
import org.nuxeo.ecm.platform.pictures.tiles.service.ImageToConvertDescriptor;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingCacheInfo;
import org.nuxeo.ecm.platform.pictures.tiles.service.TilingBlobPropertyDescriptor;
import org.nuxeo.ecm.platform.pictures.tiles.service.TilingConfigurationDescriptor;
import org.nuxeo.ecm.platform.pictures.tiles.tilers.PictureTiler;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PictureTilingComponent
extends DefaultComponent
implements PictureTilingService {
    public static final String ENV_PARAMETERS_EP = "environment";
    public static final String BLOB_PROPERTY_EP = "blobProperties";
    public static final String IMAGES_TO_CONVERT_EP = "imagesToConvert";
    protected static Map<String, PictureTilingCacheInfo> cache = new HashMap<String, PictureTilingCacheInfo>();
    protected static List<String> inprocessTiles = Collections.synchronizedList(new ArrayList());
    protected static PictureTiler defaultTiler = new MagickTiler();
    protected static Map<String, String> envParameters = new HashMap<String, String>();
    protected Map<String, String> blobProperties = new HashMap<String, String>();
    protected List<ImageToConvertDescriptor> imagesToConvert = new ArrayList<ImageToConvertDescriptor>();
    protected static Thread gcThread;
    private String workingDirPath = this.defaultWorkingDirPath();
    private static final Log log;

    public void activate(ComponentContext context) {
        defaultTiler = new MagickTiler();
        PictureTilingComponent.startGC();
    }

    public static void startGC() {
        if (!GCTask.GCEnabled) {
            GCTask.GCEnabled = true;
            log.debug((Object)"PictureTilingComponent activated starting GC thread");
            gcThread = new Thread((Runnable)new GCTask(), "Nuxeo-Tiling-GC");
            gcThread.setDaemon(true);
            gcThread.start();
            log.debug((Object)"GC Thread started");
        } else {
            log.debug((Object)"GC Thread is already started");
        }
    }

    public static void endGC() {
        if (GCTask.GCEnabled) {
            GCTask.GCEnabled = false;
            log.debug((Object)"Stopping GC Thread");
            gcThread.interrupt();
        } else {
            log.debug((Object)"GC Thread is already stopped");
        }
    }

    public void deactivate(ComponentContext context) {
        PictureTilingComponent.endGC();
    }

    public static Map<String, PictureTilingCacheInfo> getCache() {
        return cache;
    }

    protected String getWorkingDirPath() {
        return this.workingDirPath;
    }

    protected String defaultWorkingDirPath() {
        String defaultPath = new File(Environment.getDefault().getData(), "nuxeo-tiling-cache").getAbsolutePath();
        String path = PictureTilingComponent.getEnvValue("WorkingDirPath", defaultPath);
        return this.normalizeWorkingDirPath(path);
    }

    protected String normalizeWorkingDirPath(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(path = dir.getAbsolutePath()).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    @Override
    public void setWorkingDirPath(String path) {
        this.workingDirPath = this.normalizeWorkingDirPath(path);
    }

    protected String getWorkingDirPathForRessource(ImageResource resource) {
        String pathForBlob = this.getWorkingDirPath();
        String digest = resource.getHash();
        pathForBlob = pathForBlob + digest + "/";
        log.debug((Object)("WorkingDirPath for resource=" + pathForBlob));
        File wdir = new File(pathForBlob);
        if (!wdir.exists()) {
            wdir.mkdir();
        }
        return pathForBlob;
    }

    @Override
    @Deprecated
    public PictureTiles getTilesFromBlob(Blob blob, int tileWidth, int tileHeight, int maxTiles) {
        return this.getTilesFromBlob(blob, tileWidth, tileHeight, maxTiles, 0, 0, false);
    }

    @Override
    public PictureTiles getTiles(ImageResource resource, int tileWidth, int tileHeight, int maxTiles) {
        return this.getTiles(resource, tileWidth, tileHeight, maxTiles, 0, 0, false);
    }

    @Override
    public PictureTiles completeTiles(PictureTiles existingTiles, int xCenter, int yCenter) {
        String outputDirPath = existingTiles.getTilesPath();
        long lastModificationTime = Long.parseLong(existingTiles.getInfo().get(PictureTilesImpl.LAST_MODIFICATION_DATE_KEY));
        return this.computeTiles(existingTiles.getSourceImageInfo(), outputDirPath, existingTiles.getTilesWidth(), existingTiles.getTilesHeight(), existingTiles.getMaxTiles(), xCenter, yCenter, lastModificationTime, false);
    }

    @Override
    @Deprecated
    public PictureTiles getTilesFromBlob(Blob blob, int tileWidth, int tileHeight, int maxTiles, int xCenter, int yCenter, boolean fullGeneration) {
        BlobResource resource = new BlobResource(blob);
        return this.getTiles(resource, tileWidth, tileHeight, maxTiles, xCenter, yCenter, fullGeneration);
    }

    @Override
    public PictureTiles getTiles(ImageResource resource, int tileWidth, int tileHeight, int maxTiles, int xCenter, int yCenter, boolean fullGeneration) {
        log.debug((Object)"enter getTiles");
        String cacheKey = resource.getHash();
        if (defaultTiler.needsSync()) {
            while (inprocessTiles.contains(cacheKey)) {
                try {
                    log.debug((Object)"Waiting for tiler sync");
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    ExceptionUtils.checkInterrupt((Exception)e);
                }
            }
        }
        PictureTiles tiles = this.getTilesWithSync(resource, tileWidth, tileHeight, maxTiles, xCenter, yCenter, fullGeneration);
        inprocessTiles.remove(cacheKey);
        return tiles;
    }

    protected PictureTiles getTilesWithSync(ImageResource resource, int tileWidth, int tileHeight, int maxTiles, int xCenter, int yCenter, boolean fullGeneration) {
        String inputFilePath;
        PictureTilingCacheInfo cacheInfo;
        String cacheKey = resource.getHash();
        if (cache.containsKey(cacheKey)) {
            cacheInfo = cache.get(cacheKey);
            PictureTiles pt = cacheInfo.getCachedPictureTiles(tileWidth, tileHeight, maxTiles);
            if (pt != null && pt.isTileComputed(xCenter, yCenter)) {
                return pt;
            }
            inputFilePath = cacheInfo.getOriginalPicturePath();
        } else {
            File inputFile;
            String wdirPath;
            inputFilePath = wdirPath = this.getWorkingDirPathForRessource(resource);
            Blob blob = resource.getBlob();
            inputFilePath = inputFilePath + Integer.toString(blob.hashCode()) + ".";
            inputFilePath = blob.getFilename() != null ? inputFilePath + FilenameUtils.getExtension((String)blob.getFilename()) : inputFilePath + "img";
            if (this.needToConvert(blob)) {
                inputFilePath = FilenameUtils.removeExtension((String)inputFilePath) + ".jpg";
            }
            if (!(inputFile = new File(inputFilePath)).exists()) {
                try {
                    if (inputFile.createNewFile()) {
                        this.transferBlob(blob, inputFile);
                    }
                }
                catch (IOException e) {
                    String msg = String.format("Unable to transfer blob to file at '%s', working directory path: '%s'", inputFilePath, wdirPath);
                    log.error((Object)msg, (Throwable)e);
                    throw new NuxeoException(msg, (Throwable)e);
                }
                inputFile = new File(inputFilePath);
            } else {
                while (System.currentTimeMillis() - inputFile.lastModified() < 200L) {
                    try {
                        log.debug((Object)"Waiting concurrent convert / dump");
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        ExceptionUtils.checkInterrupt((Exception)e);
                    }
                }
            }
            try {
                cacheInfo = new PictureTilingCacheInfo(cacheKey, wdirPath, inputFilePath);
                cache.put(cacheKey, cacheInfo);
            }
            catch (CommandException | CommandNotAvailable e) {
                throw new NuxeoException(e);
            }
        }
        String outDirPath = cacheInfo.getTilingDir(tileWidth, tileHeight, maxTiles);
        ImageInfo bestImageInfo = cacheInfo.getBestSourceImage(tileWidth, tileHeight, maxTiles);
        inputFilePath = bestImageInfo.getFilePath();
        log.debug((Object)("input source image path for tile computation=" + inputFilePath));
        long lastModificationTime = resource.getModificationDate().getTimeInMillis();
        PictureTiles tiles = this.computeTiles(bestImageInfo, outDirPath, tileWidth, tileHeight, maxTiles, xCenter, yCenter, lastModificationTime, fullGeneration);
        tiles.getInfo().put(PictureTilesImpl.MAX_TILES_KEY, Integer.toString(maxTiles));
        tiles.getInfo().put(PictureTilesImpl.TILES_WIDTH_KEY, Integer.toString(tileWidth));
        tiles.getInfo().put(PictureTilesImpl.TILES_HEIGHT_KEY, Integer.toString(tileHeight));
        String lastModificationDate = Long.toString(lastModificationTime);
        tiles.getInfo().put(PictureTilesImpl.LAST_MODIFICATION_DATE_KEY, lastModificationDate);
        tiles.setCacheKey(cacheKey);
        tiles.setSourceImageInfo(bestImageInfo);
        tiles.setOriginalImageInfo(cacheInfo.getOriginalPictureInfos());
        cacheInfo.addPictureTilesToCache(tiles);
        return tiles;
    }

    protected void transferBlob(Blob blob, File file) throws IOException {
        if (this.needToConvert(blob)) {
            this.transferAndConvert(blob, file);
        } else {
            blob.transferTo(file);
        }
    }

    protected boolean needToConvert(Blob blob) {
        for (ImageToConvertDescriptor desc : this.imagesToConvert) {
            String extension = this.getExtension(blob);
            if (!desc.getMimeType().equalsIgnoreCase(blob.getMimeType()) && !extension.equalsIgnoreCase(desc.getExtension())) continue;
            return true;
        }
        return false;
    }

    protected String getExtension(Blob blob) {
        String filename = blob.getFilename();
        if (filename == null) {
            return "";
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return filename.substring(dotIndex + 1);
    }

    protected void transferAndConvert(Blob blob, File file) throws IOException {
        File tmpFile = new File(file.getAbsolutePath() + ".tmp");
        blob.transferTo(tmpFile);
        try {
            ImageConverter.convert((String)tmpFile.getAbsolutePath(), (String)file.getAbsolutePath());
        }
        catch (CommandException | CommandNotAvailable e) {
            throw new IOException(e);
        }
        tmpFile.delete();
    }

    protected PictureTiles computeTiles(ImageInfo input, String outputDirPath, int tileWidth, int tileHeight, int maxTiles, int xCenter, int yCenter, long lastModificationTime, boolean fullGeneration) {
        PictureTiler pt = this.getDefaultTiler();
        return pt.getTilesFromFile(input, outputDirPath, tileWidth, tileHeight, maxTiles, xCenter, yCenter, lastModificationTime, fullGeneration);
    }

    protected PictureTiler getDefaultTiler() {
        return defaultTiler;
    }

    public static void setDefaultTiler(PictureTiler tiler) {
        defaultTiler = tiler;
    }

    public static Map<String, String> getEnv() {
        return envParameters;
    }

    public static String getEnvValue(String paramName) {
        if (envParameters == null) {
            return null;
        }
        return envParameters.get(paramName);
    }

    public static String getEnvValue(String paramName, String defaultValue) {
        String value = PictureTilingComponent.getEnvValue(paramName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setEnvValue(String paramName, String paramValue) {
        envParameters.put(paramName, paramValue);
    }

    @Override
    public Map<String, String> getBlobProperties() {
        return this.blobProperties;
    }

    @Override
    public String getBlobProperty(String docType) {
        return this.blobProperties.get(docType);
    }

    @Override
    public String getBlobProperty(String docType, String defaultValue) {
        String property = this.blobProperties.get(docType);
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (ENV_PARAMETERS_EP.equals(extensionPoint)) {
            TilingConfigurationDescriptor desc = (TilingConfigurationDescriptor)contribution;
            envParameters.putAll(desc.getParameters());
            this.workingDirPath = this.defaultWorkingDirPath();
        } else if (BLOB_PROPERTY_EP.equals(extensionPoint)) {
            TilingBlobPropertyDescriptor desc = (TilingBlobPropertyDescriptor)contribution;
            this.blobProperties.putAll(desc.getBlobProperties());
        } else if (IMAGES_TO_CONVERT_EP.equals(extensionPoint)) {
            ImageToConvertDescriptor desc = (ImageToConvertDescriptor)contribution;
            this.imagesToConvert.add(desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public void removeCacheEntry(ImageResource resource) {
        if (cache.containsKey(resource.getHash())) {
            PictureTilingCacheInfo cacheInfo = cache.remove(resource.getHash());
            cacheInfo.cleanUp();
        }
    }

    static {
        log = LogFactory.getLog(PictureTilingComponent.class);
    }
}

