/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.net.URI;
import java.net.URISyntaxException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;

public class URNDocumentViewTranslator {
    public URI getNuxeoUrn(String server, String id) {
        try {
            return new URI("urn:nuxeo:" + server + ":" + id);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getUriFromDocumentView(String serverName, DocumentRef docRef) {
        try {
            return new URI("urn:nuxeo:" + serverName + ":" + docRef);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentView getDocumentViewFromUri(URI uri) {
        if (!this.isNuxeoUrn(uri)) {
            return null;
        }
        String[] tokens = uri.toString().split(":");
        IdRef ref = new IdRef(tokens[3]);
        DocumentLocationImpl dl = new DocumentLocationImpl(tokens[2], (DocumentRef)ref);
        DocumentViewImpl view = null;
        if (tokens.length < 5) {
            view = new DocumentViewImpl((DocumentLocation)dl);
        }
        return view;
    }

    public boolean isNuxeoUrn(URI uri) {
        return uri.toString().startsWith("urn:nuxeo");
    }
}

