/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.runtime.api.Framework;

public class VideoChangedListener
implements EventListener {
    private static final Log log = LogFactory.getLog(VideoChangedListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("HasVideoPreview") && !doc.isProxy()) {
            boolean forceGeneration = Boolean.TRUE.equals(doc.getContextData("forceInformationsGeneration"));
            Property origVideoProperty = doc.getProperty("file:content");
            if (forceGeneration || "documentCreated".equals(event.getName()) || origVideoProperty.isDirty()) {
                Blob video = (Blob)origVideoProperty.getValue();
                this.updateVideoInfo(doc, video);
                if ("beforeDocumentModification".equals(event.getName())) {
                    doc.setPropertyValue("vid:transcodedVideos", null);
                    doc.setPropertyValue("vid:storyboard", null);
                    doc.setPropertyValue("picture:views", null);
                }
                if (video != null) {
                    Event trigger = docCtx.newEvent("videoChanged");
                    EventService eventService = (EventService)Framework.getLocalService(EventService.class);
                    eventService.fireEvent(trigger);
                }
            }
        }
    }

    protected void updateVideoInfo(DocumentModel doc, Blob video) {
        try {
            VideoHelper.updateVideoInfo(doc, video);
        }
        catch (NuxeoException e) {
            log.error((Object)String.format("Unable to retrieve video info: %s", e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
    }
}

