/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class PictureConversionRegistry
extends ContributionFragmentRegistry<PictureConversion> {
    private static final Log log = LogFactory.getLog(PictureConversionRegistry.class);
    protected final Map<String, PictureConversion> pictureConversions = new HashMap<String, PictureConversion>();

    public PictureConversion getPictureConversion(String id) {
        return this.pictureConversions.get(id);
    }

    public List<PictureConversion> getPictureConversions() {
        ArrayList<PictureConversion> entries = new ArrayList<PictureConversion>(this.pictureConversions.values());
        Collections.sort(entries);
        return entries;
    }

    public String getContributionId(PictureConversion pictureConversion) {
        return pictureConversion.getId();
    }

    public void contributionUpdated(String id, PictureConversion pictureConversion, PictureConversion oldPictureConversion) {
        if (this.pictureConversions.containsKey(id)) {
            this.contributionRemoved(id, pictureConversion);
        }
        if (pictureConversion.isEnabled()) {
            if (!StringUtils.isBlank((String)id)) {
                this.pictureConversions.put(id, pictureConversion);
            } else {
                log.warn((Object)String.format("Missing 'id' for picture conversion %s, not registering it.", pictureConversion));
            }
        }
    }

    public void contributionRemoved(String id, PictureConversion pictureConversion) {
        this.pictureConversions.remove(id);
    }

    public PictureConversion clone(PictureConversion pictureConversion) {
        return pictureConversion.clone();
    }

    public void merge(PictureConversion source, PictureConversion dest) {
        Integer maxSize;
        Integer order;
        String description;
        String tag;
        String chainId;
        if (source.isEnabledSet() && source.isEnabled() != dest.isEnabled()) {
            dest.setEnabled(source.isEnabled());
        }
        if (source.isDefaultSet() && source.isDefault()) {
            dest.setDefault(source.isDefault());
        }
        if (!dest.isEnabled() && dest.isDefault()) {
            dest.setEnabled(true);
            if (log.isWarnEnabled()) {
                String message = String.format("The picture conversion '%s' is marked as default, enabling it.", dest.getId());
                log.warn((Object)message);
            }
        }
        if (!StringUtils.isBlank((String)(chainId = source.getChainId()))) {
            dest.setChainId(chainId);
        }
        if (!StringUtils.isBlank((String)(tag = source.getTag()))) {
            dest.setTag(tag);
        }
        if (!StringUtils.isBlank((String)(description = source.getDescription()))) {
            dest.setDescription(description);
        }
        if ((order = source.getOrder()) != null) {
            dest.setOrder(order);
        }
        if ((maxSize = source.getMaxSize()) != null) {
            dest.setMaxSize(maxSize);
        }
        ArrayList newFilterIds = new ArrayList();
        newFilterIds.addAll(dest.getFilterIds());
        newFilterIds.addAll(source.getFilterIds());
        dest.setFilterIds(newFilterIds);
        if (source.isRenditionSet()) {
            dest.setRendition(Boolean.valueOf(source.isRendition()));
        }
        if (source.isRenditionVisibleSet()) {
            dest.setRenditionVisible(Boolean.valueOf(source.isRenditionVisible()));
        }
    }
}

