/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerAdapter;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfo;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModel;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModelListener;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util.Point;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util.Rectangle;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view.SelectedArea;

public class TilingPreviewControllerPanel
extends FocusPanel
implements TilingModelListener {
    private static final String DEFAULT_CLASS_NAME = "tilingPreviewControllerPanel";
    private final TilingInfo sourceTilingInfo;
    private final TilingModel model;
    private int totalWidth;
    private int totalHeight;
    private AbsolutePanel imagesPanel;
    private double factor = 1.0;
    private SelectedArea selectedArea;
    private final Anchor anchor = new Anchor();
    private final SimplePanel area = new SimplePanel();
    private final FocusPanel anchorContainer = new FocusPanel((Widget)this.anchor);
    private final ControllerMouseListener controllerMouseListener = new ControllerMouseListener();
    private final ControllerBlockAllEventsListener blockAllEventsListener = new ControllerBlockAllEventsListener();

    public TilingPreviewControllerPanel(TilingInfo sourceTilingInfo, TilingModel model) {
        this.sourceTilingInfo = sourceTilingInfo;
        this.model = model;
        model.addListener(this);
        this.imagesPanel = new AbsolutePanel();
        this.totalWidth = (int)Math.round((double)sourceTilingInfo.getOriginalImageWidth() * sourceTilingInfo.getZoom());
        this.totalHeight = (int)Math.round((double)sourceTilingInfo.getOriginalImageHeight() * sourceTilingInfo.getZoom());
        this.imagesPanel.setPixelSize(this.totalWidth, this.totalHeight);
        this.setWidget((Widget)this.imagesPanel);
        this.loadImages();
        this.createSelectedArea();
        this.addMouseListener((MouseListener)this.controllerMouseListener);
        this.setStyleName(DEFAULT_CLASS_NAME);
    }

    private void loadImages() {
        int heightInTiles = this.sourceTilingInfo.getNbYTiles();
        int widthInTiles = this.sourceTilingInfo.getNbXTiles();
        for (int y = 0; y < heightInTiles; ++y) {
            for (int x = 0; x < widthInTiles; ++x) {
                String imageUrl = this.sourceTilingInfo.getBaseUrl() + "?x=" + x + "&y=" + y;
                imageUrl = imageUrl + "&date=" + this.sourceTilingInfo.getLastModificationDate();
                Image image = new Image(imageUrl){

                    public void onBrowserEvent(Event event) {
                    }
                };
                int imageX = x * this.sourceTilingInfo.getTileWidth();
                int imageY = y * this.sourceTilingInfo.getTileHeight();
                this.imagesPanel.add((Widget)image, imageX, imageY);
            }
        }
        this.imagesPanel.add((Widget)this.area);
    }

    private void createSelectedArea() {
        this.selectedArea = new SelectedArea(this.totalWidth, this.totalHeight, (Panel)this.imagesPanel);
    }

    private void reloadSelectedArea() {
        this.factor = this.model.getCurrentZoom() / this.sourceTilingInfo.getZoom();
        int left = (int)Math.round((double)this.model.getViewAreaLeft() / this.factor);
        int top = (int)Math.round((double)this.model.getViewAreaTop() / this.factor);
        int w = (int)Math.round((double)this.model.getViewAreaWidth() / this.factor);
        int h = (int)Math.round((double)this.model.getViewAreaHeight() / this.factor);
        int maxW = (int)Math.round((double)this.sourceTilingInfo.getOriginalImageWidth() * this.sourceTilingInfo.getZoom());
        int maxH = (int)Math.round((double)this.sourceTilingInfo.getOriginalImageHeight() * this.sourceTilingInfo.getZoom());
        Log.debug((String)("w: " + w + " maxW: " + maxW + " h: " + h + " maxH: " + maxH));
        if (w > maxW) {
            w = maxW;
        }
        if (h > maxH) {
            h = maxH;
        }
        Point topLeft = new Point(left, top);
        Rectangle area = new Rectangle(topLeft, w, h);
        if (this.sourceTilingInfo.getZoom() == this.model.getCurrentZoom()) {
            this.imagesPanel.remove((Widget)this.anchorContainer);
            this.removeMouseListener((MouseListener)this.controllerMouseListener);
            this.addMouseListener((MouseListener)this.blockAllEventsListener);
        } else {
            this.imagesPanel.add((Widget)this.anchorContainer);
            this.removeMouseListener((MouseListener)this.blockAllEventsListener);
            this.addMouseListener((MouseListener)this.controllerMouseListener);
        }
        this.selectedArea.changeArea(area);
    }

    private void updateModel() {
        Point center = this.selectedArea.getCurrentArea().getCenter();
        int x = (int)Math.round((double)center.getX() * this.factor);
        int y = (int)Math.round((double)center.getY() * this.factor);
        this.model.centerOn(x, y);
        this.selectedArea.putArea();
    }

    private void moveArea(int dx, int dy) {
        this.selectedArea.move(dx, dy);
    }

    private void centerArea(int x, int y) {
        this.selectedArea.centerOn(x, y);
    }

    private static void cancelEvent(Event event) {
        event.preventDefault();
        event.cancelBubble(true);
    }

    @Override
    public void onModelChange(TilingModel.TilingModelEvent event, TilingModel model) {
        switch (event) {
            case TILING_INFO_UPDATED: {
                this.reloadSelectedArea();
                this.selectedArea.putArea();
            }
        }
    }

    private class ControllerBlockAllEventsListener
    extends MouseListenerAdapter {
        private ControllerBlockAllEventsListener() {
        }

        public void onMouseDown(Widget sender, int x, int y) {
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }

        public void onMouseEnter(Widget sender) {
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }

        public void onMouseLeave(Widget sender) {
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }

        public void onMouseMove(Widget sender, int x, int y) {
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }

        public void onMouseUp(Widget sender, int x, int y) {
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }
    }

    private class ControllerMouseListener
    extends MouseListenerAdapter {
        boolean mouseDown = false;
        int x;
        int y;

        private ControllerMouseListener() {
        }

        public void onMouseDown(Widget sender, int x, int y) {
            this.mouseDown = true;
            this.x = x;
            this.y = y;
            TilingPreviewControllerPanel.this.centerArea(x, y);
            DOM.setStyleAttribute((Element)TilingPreviewControllerPanel.this.imagesPanel.getElement(), (String)"cursor", (String)"move");
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }

        public void onMouseMove(Widget sender, int x, int y) {
            if (this.mouseDown) {
                TilingPreviewControllerPanel.this.moveArea(x - this.x, y - this.y);
                this.x = x;
                this.y = y;
            }
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }

        public void onMouseUp(Widget sender, int x, int y) {
            if (this.mouseDown) {
                this.mouseDown = false;
                TilingPreviewControllerPanel.this.moveArea(x - this.x, y - this.y);
                TilingPreviewControllerPanel.this.updateModel();
                DOM.setStyleAttribute((Element)TilingPreviewControllerPanel.this.imagesPanel.getElement(), (String)"cursor", (String)"default");
                TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
            }
        }

        public void onMouseLeave(Widget sender) {
            this.onMouseUp(sender, this.x, this.y);
            TilingPreviewControllerPanel.cancelEvent(Event.getCurrentEvent());
        }
    }
}

