/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools.operations;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoToolsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Video.SliceInParts", category="Conversion", label="SliceVideo a Video in Parts with equal duration.", description="Slices the video in n parts of approximately the same duration each.", aliases={"Video.SliceInParts"})
public class SliceVideoInParts {
    public static final String ID = "Video.SliceInParts";
    @Param(name="duration", required=false)
    protected String duration;
    @Param(name="xpath", required=false)
    protected String xpath;

    @OperationMethod
    public BlobList run(DocumentModel input) throws OperationException {
        if (StringUtils.isEmpty((String)this.xpath)) {
            return this.run(((BlobHolder)input.getAdapter(BlobHolder.class)).getBlob());
        }
        return this.run((Blob)input.getPropertyValue(this.xpath));
    }

    @OperationMethod
    public BlobList run(Blob input) throws OperationException {
        try {
            VideoToolsService service = (VideoToolsService)Framework.getService(VideoToolsService.class);
            return new BlobList(service.slice(input, "", this.duration, false));
        }
        catch (NuxeoException e) {
            throw new OperationException((Throwable)e);
        }
    }
}

