/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageResizer;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.helpers.StringMaker;
import org.nuxeo.runtime.api.Framework;

public class PictureTilingCacheInfo {
    public static int SHRINK_DOWN_LIMIT_PX = 2000;
    private static final Log log = LogFactory.getLog(PictureTilingCacheInfo.class);
    protected String cacheKey;
    protected String workingDir;
    protected ImageInfo originalPictureInfos;
    protected Map<Integer, ImageInfo> shrinkedImages;
    protected List<Integer> shrinkedImagesWidths;
    protected Map<String, PictureTiles> tilesSet;
    protected String syncShrink = "oneOncePerInstance";
    protected Date lastAccessTime;

    protected void updateAccessTime() {
        this.lastAccessTime = new Date();
    }

    public Date getLastAccessedTime() {
        return this.lastAccessTime;
    }

    protected long getFileSize(String path) {
        if (path == null) {
            return 0L;
        }
        File file = new File(path);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public long getDiskSpaceUsageInBytes() {
        long diskSpaceUsage = 0L;
        diskSpaceUsage += this.getFileSize(this.originalPictureInfos.getFilePath());
        for (Integer s : this.shrinkedImages.keySet()) {
            diskSpaceUsage += this.getFileSize(this.shrinkedImages.get(s).getFilePath());
        }
        for (String tileDef : this.tilesSet.keySet()) {
            PictureTiles tiles = this.tilesSet.get(tileDef);
            File tileDir = new File(tiles.getTilesPath());
            if (!tileDir.exists()) continue;
            for (File tileFile : tileDir.listFiles()) {
                diskSpaceUsage += tileFile.length();
            }
        }
        return diskSpaceUsage;
    }

    public PictureTilingCacheInfo(String cacheKey, String workingDir, String filePath) throws CommandNotAvailable, CommandException {
        this.cacheKey = cacheKey;
        this.workingDir = workingDir;
        this.originalPictureInfos = ImageIdentifier.getInfo((String)filePath);
        this.shrinkedImages = new HashMap<Integer, ImageInfo>();
        this.shrinkedImagesWidths = new ArrayList<Integer>();
        this.tilesSet = new HashMap<String, PictureTiles>();
        this.updateAccessTime();
    }

    public void addPictureTilesToCache(PictureTiles tiles) {
        this.tilesSet.put(tiles.getTileFormatCacheKey(), tiles);
        this.updateAccessTime();
    }

    public PictureTiles getCachedPictureTiles(int tileWidth, int tileHeight, int maxTiles) {
        String ptKey = StringMaker.getTileFormatString(tileWidth, tileHeight, maxTiles);
        this.updateAccessTime();
        return this.tilesSet.get(ptKey);
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getOriginalPicturePath() {
        return this.originalPictureInfos.getFilePath();
    }

    public String getTilingDir(int tileWidth, int tileHeight, int maxTiles) {
        String dirPath = "tiles-" + tileWidth + "-" + tileHeight + "-" + maxTiles;
        dirPath = new Path(this.workingDir).append(dirPath).toString();
        log.debug((Object)("Target tiling dir=" + dirPath));
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdir();
            Framework.trackFile((File)dir, (Object)this);
        }
        return dirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo getBestSourceImage(int tileWidth, int tileHeight, int maxTiles) {
        this.updateAccessTime();
        if ("JPEG".equals(this.originalPictureInfos.getFormat())) {
            if (this.originalPictureInfos.getHeight() > SHRINK_DOWN_LIMIT_PX || this.originalPictureInfos.getWidth() > SHRINK_DOWN_LIMIT_PX) {
                int neededWidth = tileWidth * maxTiles;
                int neededHeight = tileHeight * maxTiles;
                int shrinkedWidth = 0;
                if (neededHeight > this.originalPictureInfos.getHeight() / 2 || neededWidth > this.originalPictureInfos.getWidth() / 2) {
                    return this.originalPictureInfos;
                }
                String string = this.syncShrink;
                synchronized (string) {
                    for (Integer swidth : this.shrinkedImagesWidths) {
                        if (swidth < neededWidth) break;
                        shrinkedWidth = swidth;
                    }
                    if (shrinkedWidth > 0) {
                        return this.shrinkedImages.get(new Integer(shrinkedWidth));
                    }
                    String shrinkedImagePath = new Path(this.workingDir).append("reduced-" + neededWidth + "x" + neededHeight + ".jpg").toString();
                    try {
                        ImageInfo shrinked = ImageResizer.resize((String)this.originalPictureInfos.getFilePath(), (String)shrinkedImagePath, (int)neededWidth, (int)neededHeight, (int)-1);
                        this.shrinkedImagesWidths.add(new Integer(shrinked.getWidth()));
                        Collections.sort(this.shrinkedImagesWidths);
                        Collections.reverse(this.shrinkedImagesWidths);
                        this.shrinkedImages.put(new Integer(shrinked.getWidth()), shrinked);
                        return shrinked;
                    }
                    catch (CommandException | CommandNotAvailable e) {
                        return this.originalPictureInfos;
                    }
                }
            }
            return this.originalPictureInfos;
        }
        return this.originalPictureInfos;
    }

    public ImageInfo getOriginalPictureInfos() {
        this.updateAccessTime();
        return this.originalPictureInfos;
    }

    public void cleanUp() {
        File orgFile = new File(this.originalPictureInfos.getFilePath());
        if (orgFile.exists()) {
            orgFile.delete();
        }
        for (Integer s : this.shrinkedImages.keySet()) {
            File skFile = new File(this.shrinkedImages.get(s).getFilePath());
            if (!skFile.exists()) continue;
            skFile.delete();
        }
        for (String tileDef : this.tilesSet.keySet()) {
            PictureTiles tiles = this.tilesSet.get(tileDef);
            File tileDir = new File(tiles.getTilesPath());
            if (!tileDir.exists()) continue;
            for (File tileFile : tileDir.listFiles()) {
                tileFile.delete();
            }
        }
    }

    public void partialCleanUp(long targetDeltaInKB) {
        long deletedKB = 0L;
        for (String tileDef : this.tilesSet.keySet()) {
            PictureTiles tiles = this.tilesSet.get(tileDef);
            File tileDir = new File(tiles.getTilesPath());
            if (!tileDir.exists()) continue;
            for (File tileFile : tileDir.listFiles()) {
                tileFile.delete();
                if ((deletedKB += tileFile.length() / 1000L) <= targetDeltaInKB) continue;
                return;
            }
        }
        for (Integer s : this.shrinkedImages.keySet()) {
            File skFile = new File(this.shrinkedImages.get(s).getFilePath());
            if (!skFile.exists()) continue;
            skFile.delete();
            if ((deletedKB += skFile.length() / 1000L) <= targetDeltaInKB) continue;
            return;
        }
        File orgFile = new File(this.originalPictureInfos.getFilePath());
        if (orgFile.exists()) {
            orgFile.delete();
        }
    }
}

