/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.validation.client.ProviderValidationMessageResolver;
import com.google.gwt.validation.client.UserValidationMessagesResolver;
import com.google.gwt.validation.client.ValidationMessageResolver;
import java.util.Map;
import javax.validation.MessageInterpolator;

abstract class BaseMessageInterpolator
implements MessageInterpolator {
    private static final RegExp MESSAGE_PARAMETER_PATTERN = RegExp.compile("(\\{[^\\}]+?\\})", "g");
    private final Function<String, String> providerReplacer = BaseMessageInterpolator.createReplacer((ValidationMessageResolver)GWT.create(ProviderValidationMessageResolver.class));
    private final Function<String, String> userReplacer;

    static Function<String, String> createAnnotationReplacer(final Map<String, Object> map) {
        return new Function<String, String>(){

            @Override
            public String apply(String from) {
                Object object = map.get(from);
                return object == null ? null : object.toString();
            }
        };
    }

    private static Function<String, String> createReplacer(final ValidationMessageResolver messageResolver) {
        return new Function<String, String>(){

            @Override
            public String apply(String from) {
                String object = messageResolver.get(from);
                return object == null ? null : object.toString();
            }
        };
    }

    protected BaseMessageInterpolator(UserValidationMessagesResolver userValidationMessagesResolver) {
        this.userReplacer = BaseMessageInterpolator.createReplacer(userValidationMessagesResolver);
    }

    public final String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        return this.gwtInterpolate(messageTemplate, context, null);
    }

    protected final String gwtInterpolate(String message, MessageInterpolator.Context context, GwtLocale locale) {
        String step1message;
        String resolvedMessage = message;
        while (!(step1message = resolvedMessage).equals(resolvedMessage = this.replaceParameters(resolvedMessage, this.userReplacer)) || !step1message.equals(resolvedMessage = this.replaceParameters(resolvedMessage, this.providerReplacer))) {
        }
        resolvedMessage = this.replaceParameters(resolvedMessage, BaseMessageInterpolator.createAnnotationReplacer(context.getConstraintDescriptor().getAttributes()));
        resolvedMessage = resolvedMessage.replace("\\{", "{");
        resolvedMessage = resolvedMessage.replace("\\}", "}");
        resolvedMessage = resolvedMessage.replace("\\\\", "\\");
        return resolvedMessage;
    }

    protected final String replaceParameters(String message, Function<String, String> replacer) {
        MatchResult matcher;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while ((matcher = MESSAGE_PARAMETER_PATTERN.exec(message)) != null) {
            String matched = matcher.getGroup(0);
            sb.append(message.substring(index, matcher.getIndex()));
            String value = replacer.apply(this.removeCurlyBrace(matched));
            sb.append((Object)(value == null ? matched : value));
            index = MESSAGE_PARAMETER_PATTERN.getLastIndex();
        }
        if (index < message.length()) {
            sb.append(message.substring(index));
        }
        return sb.toString();
    }

    private String removeCurlyBrace(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private static interface Function<F, T> {
        public T apply(F var1);
    }
}

