/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.i18n.client.Dictionary;
import java.util.MissingResourceException;

public class PreviewSettings {
    private static final String PREVIEW_SETTINGS = "previewSettings";
    private static final String IMAGE_ONLY = "imageOnly";
    private static final String MULTI_IMAGE_ANNOTATION = "multiImageAnnotation";
    private static final String XPOINTER_FILTER_PATH = "xPointerFilterPath";
    private static final String POINTER_ADAPTER = "pointerAdapter";
    private static final String ANNOTATION_DECORATOR_FUNCTION = "annotationDecoratorFunction";
    private static PreviewSettings INSTANCE;
    private Dictionary dictionary = Dictionary.getDictionary((String)"previewSettings");

    public static PreviewSettings getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new PreviewSettings();
            }
            catch (MissingResourceException e) {
                Log.debug((String)"Preview Settings dictionary not found");
                INSTANCE = null;
            }
        }
        return INSTANCE;
    }

    private String get(String key) {
        try {
            return this.dictionary.get(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public boolean isImageOnly() {
        String imageOnly = this.get(IMAGE_ONLY);
        return imageOnly != null ? Boolean.parseBoolean(imageOnly) : false;
    }

    public boolean isMultiImageAnnotation() {
        String multiImageAnnotation = this.get(MULTI_IMAGE_ANNOTATION);
        return multiImageAnnotation != null ? Boolean.parseBoolean(multiImageAnnotation) : false;
    }

    public String getXPointerFilterPath() {
        return this.get(XPOINTER_FILTER_PATH);
    }

    public String getPointerAdapter() {
        return this.get(POINTER_ADAPTER);
    }

    public String getAnnotationDecoratorFunction() {
        return this.get(ANNOTATION_DECORATOR_FUNCTION);
    }
}

