/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.net.URI;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryComponent;
import org.nuxeo.ecm.platform.annotations.repository.service.DocumentVersionnedGraphManager;
import org.nuxeo.ecm.platform.annotations.repository.service.GraphManagerEventListener;
import org.nuxeo.runtime.api.Framework;

public class ResetCheckedoutGraphListener
implements GraphManagerEventListener {
    protected final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();
    protected final GraphManagerEventListener copyManager = new DocumentVersionnedGraphManager();

    @Override
    public void manage(Event event) {
        this.copyManager.manage(event);
        if (!"documentCheckedIn".equals(event.getName())) {
            return;
        }
        EventContext context = event.getContext();
        CoreSession session = context.getCoreSession();
        DocumentModel doc = (DocumentModel)context.getArguments()[0];
        String repo = doc.getRepositoryName();
        this.removeGraphFor(session, repo, doc, (NuxeoPrincipal)context.getPrincipal());
    }

    protected void removeGraphFor(CoreSession session, String repositoryName, DocumentModel doc, NuxeoPrincipal user) {
        URI uri = this.translator.getNuxeoUrn(repositoryName, doc.getId());
        AnnotationsService service = (AnnotationsService)Framework.getService(AnnotationsService.class);
        List annotations = service.queryAnnotations(uri, user);
        for (Annotation annotation : annotations) {
            AnnotationsRepositoryComponent.instance.injector.removeAnnotationText(doc, annotation.getId());
            session.saveDocument(doc);
            service.deleteAnnotationFor(uri, annotation, user);
        }
    }
}

