/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoInfo;

public final class TranscodedVideo
extends Video {
    private static final String NAME = "name";
    private static final String CONTENT = "content";
    private static final String INFO = "info";
    private final String name;
    private final int position;

    public static TranscodedVideo fromMapAndPosition(Map<String, Serializable> map, int position) {
        Blob blob = (Blob)map.get(CONTENT);
        Map info = (Map)((Object)map.get(INFO));
        VideoInfo videoInfo = VideoInfo.fromMap(info);
        String name = (String)((Object)map.get(NAME));
        return new TranscodedVideo(blob, videoInfo, name, position);
    }

    public static TranscodedVideo fromBlobAndInfo(String name, Blob blob, VideoInfo videoInfo) {
        return new TranscodedVideo(blob, videoInfo, name, -1);
    }

    private TranscodedVideo(Blob blob, VideoInfo videoInfo, String name, int position) {
        super(blob, videoInfo);
        this.name = name;
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public String getBlobPropertyName() {
        if (this.position == -1) {
            throw new IllegalStateException("This transcoded video is not yet persisted, cannot generate property name.");
        }
        return "vid:transcodedVideos/" + this.position + "/content";
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(NAME, (Serializable)((Object)this.name));
        map.put(CONTENT, (Serializable)this.blob);
        map.put(INFO, (Serializable)((Object)this.videoInfo.toMap()));
        return map;
    }
}

