/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audio.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ThumbnailAudioFactory
implements ThumbnailFactory {
    private static final Log log = LogFactory.getLog(ThumbnailAudioFactory.class);

    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        if (!doc.hasFacet("Audio")) {
            throw new NuxeoException("Document is not audio type");
        }
        Blob thumbnailBlob = null;
        try {
            if (doc.hasFacet("Thumbnail")) {
                thumbnailBlob = (Blob)doc.getPropertyValue("thumb:thumbnail");
            }
        }
        catch (PropertyException e) {
            log.warn((Object)"Could not fetch the thumbnail blob", (Throwable)e);
        }
        if (thumbnailBlob == null) {
            TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
            try {
                return Blobs.createBlob((File)FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return thumbnailBlob;
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        Blob thumbnailBlob = null;
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        try {
            Iterator it;
            Blob fileBlob;
            try (InputStream in = bh.getBlob().getStream();){
                fileBlob = Blobs.createBlob((InputStream)in);
            }
            MP3File file = new MP3File(fileBlob.getFile());
            if (file.hasID3v2Tag() && (it = file.getID3v2Tag().getFrameOfType("APIC")) != null && it.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)it.next();
                FrameBodyAPIC framePic = (FrameBodyAPIC)frame.getBody();
                thumbnailBlob = Blobs.createBlob((byte[])framePic.getImageData());
            }
        }
        catch (IOException | InvalidAudioFrameException | ReadOnlyFileException | TagException e) {
            log.warn((Object)"Unable to get the audio file cover art", e);
        }
        return thumbnailBlob;
    }
}

