/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.server.configuration;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.configuration.service.FilterDescriptor;
import org.nuxeo.ecm.platform.annotations.configuration.service.WebAnnotationConfigurationService;
import org.nuxeo.ecm.platform.annotations.configuration.service.WebAnnotationDefinitionDescriptor;
import org.nuxeo.ecm.platform.annotations.configuration.service.WebAnnotationFieldDescriptor;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationDefinition;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfigurationService;
import org.nuxeo.ecm.platform.annotations.gwt.server.configuration.UserInfoMapper;
import org.nuxeo.ecm.platform.annotations.gwt.server.configuration.WebPermission;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class WebConfigurationServiceImpl
extends RemoteServiceServlet
implements WebConfigurationService {
    private static final long serialVersionUID = 2389527283775608787L;
    private static final Log log = LogFactory.getLog(WebConfigurationServiceImpl.class);
    private WebAnnotationConfigurationService webAnnotationConfigurationService;
    protected DocumentViewCodecManager documentViewCodecManager;
    private NuxeoPrincipal currentUser;

    protected WebAnnotationConfigurationService getConfig() {
        if (this.webAnnotationConfigurationService == null) {
            this.webAnnotationConfigurationService = (WebAnnotationConfigurationService)Framework.getService(WebAnnotationConfigurationService.class);
        }
        return this.webAnnotationConfigurationService;
    }

    @Override
    public WebConfiguration getWebConfiguration(String url) {
        WebPermission webPermission;
        WebConfiguration conf = new WebConfiguration();
        List<WebAnnotationDefinitionDescriptor> types = this.getConfig().getEnabledWebAnnotationDefinitions();
        for (WebAnnotationDefinitionDescriptor type : types) {
            HashMap<String, String[]> fields = new HashMap<String, String[]>();
            for (WebAnnotationFieldDescriptor field : type.getFields()) {
                fields.put(field.getName(), field.getChoices());
            }
            conf.addAnnotationDefinition(new AnnotationDefinition(type.getUri(), type.getName(), type.getIcon(), type.getType(), type.getListIcon(), type.getCreateIcon(), type.isInMenu(), fields));
        }
        UserInfoMapper userInfoMapper = this.getConfig().getUserInfoMapper();
        if (userInfoMapper != null) {
            conf.setUserInfo(userInfoMapper.getUserInfo(this.currentUser));
        }
        if ((webPermission = this.getConfig().getWebPermission()) != null) {
            conf.setCanAnnotate(this.canAnnotate(url, webPermission));
        }
        Map<String, FilterDescriptor> filters = this.getConfig().getFilterDefinitions();
        for (FilterDescriptor filter : filters.values()) {
            conf.addFilter(filter.getOrder(), filter.getName(), filter.getIcon(), filter.getType(), filter.getAuthor(), filter.getFields());
        }
        conf.setDisplayedFields(this.getConfig().getDisplayedFields());
        conf.setFieldLabels(this.getConfig().getFieldLabels());
        return conf;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.currentUser = (NuxeoPrincipal)request.getUserPrincipal();
        super.service(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canAnnotate(String url, WebPermission webPermission) {
        DocumentViewCodecManager documentViewCodecManager = this.getDocumentViewCodecManager();
        DocumentView docView = documentViewCodecManager.getDocumentViewFromUrl(url, true, this.getBaseUrl(url));
        DocumentLocation docLocation = docView.getDocumentLocation();
        try (CoreSession coreSession = CoreInstance.openCoreSession((String)docLocation.getServerName());){
            DocumentModel docModel = coreSession.getDocument(docLocation.getDocRef());
            boolean bl = webPermission.canAnnotate(docModel);
            return bl;
        }
        catch (DocumentNotFoundException e) {
            log.error((Object)("Unable to get Document: " + docLocation.getDocRef()), (Throwable)e);
            return true;
        }
    }

    protected DocumentViewCodecManager getDocumentViewCodecManager() {
        if (this.documentViewCodecManager == null) {
            this.documentViewCodecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        return this.documentViewCodecManager;
    }

    protected String getBaseUrl(String url) {
        String nxUrl = VirtualHostHelper.getContextPathProperty() + "/";
        return url.substring(0, url.lastIndexOf(nxUrl) + nxUrl.length());
    }
}

