/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.net.URI;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryService;
import org.nuxeo.ecm.platform.annotations.service.AnnotabilityManager;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class RepositoryAnnotabilityManager
implements AnnotabilityManager {
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();
    private AnnotationsRepositoryService service = (AnnotationsRepositoryService)Framework.getService(AnnotationsRepositoryService.class);

    public boolean isAnnotable(URI uri) {
        DocumentView view = this.translator.getDocumentViewFromUri(uri);
        if (view == null) {
            return this.service.isAnnotable(null);
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
            DocumentModel model = session.getDocument(view.getDocumentLocation().getDocRef());
            boolean bl = this.service.isAnnotable(model);
            return bl;
        }
    }
}

