/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.imageresource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.ImageResource;

public class BlobResource
implements ImageResource {
    private static final long serialVersionUID = 1L;
    protected Blob blob;
    protected String hash;
    protected Calendar modified;

    public BlobResource(Blob blob) {
        this.blob = blob;
        this.hash = blob.getDigest() != null ? blob.getDigest() : this.getMD5Digest();
        this.modified = Calendar.getInstance();
    }

    @Override
    public Blob getBlob() {
        return this.blob;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public Calendar getModificationDate() {
        return this.modified;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMD5Digest() {
        try (InputStream in = this.blob.getStream();){
            String string = DigestUtils.md5Hex((InputStream)in);
            return string;
        }
        catch (IOException e) {
            return this.blob.hashCode() + "fakeHash";
        }
    }
}

