/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.adapter;

import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapterImpl;
import org.nuxeo.runtime.api.Framework;

public class PictureTilesAdapterFactory
implements DocumentAdapterFactory {
    protected static final String ORIGINAL_JPEG_VIEW_NAME = "OriginalJpeg";
    @Deprecated
    protected static final String ORIGINAL_VIEW_NAME = "Original";

    public Object getAdapter(DocumentModel doc, Class itf) {
        PictureTilingService tilingService = (PictureTilingService)Framework.getService(PictureTilingService.class);
        String blobProperty = tilingService.getBlobProperty(doc.getType());
        PictureTilesAdapter ptAdapter = this.getPictureTilesAdapterFor(doc, blobProperty);
        if (ptAdapter != null) {
            return ptAdapter;
        }
        if (doc.hasSchema("file")) {
            Blob blob = (Blob)doc.getProperty("file", "content");
            if (blob == null) {
                return null;
            }
            return new PictureTilesAdapterImpl(doc, "file:content");
        }
        return new PictureTilesAdapterImpl(doc);
    }

    private PictureTilesAdapter getPictureTilesAdapterFor(DocumentModel doc, String blobProperty) {
        if (blobProperty != null) {
            try {
                return this.getPictureTilesAdapter(doc, blobProperty);
            }
            catch (IndexOutOfBoundsException | PropertyException e) {
                return this.getPictureTilesAdapterForPicture(doc);
            }
        }
        return this.getPictureTilesAdapterForPicture(doc);
    }

    private PictureTilesAdapter getPictureTilesAdapterForPicture(DocumentModel doc) {
        if (doc.hasSchema("picture")) {
            PictureResourceAdapter adapter = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            String blobProperty = adapter.getViewXPath(ORIGINAL_JPEG_VIEW_NAME) + "content";
            return this.getPictureTilesAdapter(doc, blobProperty);
        }
        return null;
    }

    private PictureTilesAdapter getPictureTilesAdapter(DocumentModel doc, String blobProperty) {
        Blob blob = (Blob)doc.getPropertyValue(blobProperty);
        if (blob != null) {
            return new PictureTilesAdapterImpl(doc, blobProperty);
        }
        return null;
    }
}

