/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools.operations;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoToolsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Video.AddWatermark", category="Files", label="Watermarks a Video with a Picture", description="Watermark the video with the picture stored in file:content of watermark, at the position(x, y) from the left-top corner of the picture.")
public class AddWatermarkToVideo {
    public static final String ID = "Video.AddWatermark";
    @Param(name="watermark")
    protected DocumentModel watermark;
    @Param(name="x", required=false, values={"0"})
    protected String x;
    @Param(name="y", required=false, values={"0"})
    protected String y;
    @Param(name="xpath", required=false)
    protected String xpath;

    @OperationMethod
    public Blob run(DocumentModel input) throws OperationException {
        if (StringUtils.isEmpty((CharSequence)this.xpath)) {
            return this.run(((BlobHolder)input.getAdapter(BlobHolder.class)).getBlob());
        }
        return this.run((Blob)input.getPropertyValue(this.xpath));
    }

    @OperationMethod
    public BlobList run(DocumentModelList input) throws OperationException {
        BlobList blobList = new BlobList();
        String blobPath = StringUtils.isEmpty((CharSequence)this.xpath) ? "file:content" : this.xpath;
        for (DocumentModel doc : input) {
            blobList.add((Object)this.run((Blob)doc.getPropertyValue(blobPath)));
        }
        return blobList;
    }

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob input) throws OperationException {
        Blob watermarkBlob = (Blob)this.watermark.getPropertyValue("file:content");
        try {
            VideoToolsService service = (VideoToolsService)Framework.getService(VideoToolsService.class);
            return service.watermark(input, watermarkBlob, this.x, this.y);
        }
        catch (NuxeoException e) {
            throw new OperationException("Cannot add the watermark to the video.", (Throwable)e);
        }
    }
}

