/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.reference.PictureTypes;

public class Artwork {
    private byte[] binaryData;
    private String mimeType = "";
    private String description = "";
    private boolean isLinked = false;
    private String imageUrl = "";
    private int pictureType = -1;

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BufferedImage getImage() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.getBinaryData());
        ImageInputStream iis = ImageIO.createImageInputStream(bais);
        BufferedImage bi = ImageIO.read(iis);
        return bi;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void setLinked(boolean linked) {
        this.isLinked = linked;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(int pictureType) {
        this.pictureType = pictureType;
    }

    public void setFromFile(File file) throws IOException {
        RandomAccessFile imageFile = new RandomAccessFile(file, "r");
        byte[] imagedata = new byte[(int)imageFile.length()];
        imageFile.read(imagedata);
        imageFile.close();
        this.setBinaryData(imagedata);
        this.setMimeType(ImageFormats.getMimeTypeForBinarySignature(imagedata));
        this.setDescription("");
        this.setPictureType(PictureTypes.DEFAULT_ID);
    }

    public static Artwork createArtworkFromFile(File file) throws IOException {
        Artwork artwork = new Artwork();
        artwork.setFromFile(file);
        return artwork;
    }

    public void setFromMetadataBlockDataPicture(MetadataBlockDataPicture coverArt) {
        this.setMimeType(coverArt.getMimeType());
        this.setDescription(coverArt.getDescription());
        this.setPictureType(coverArt.getPictureType());
        if (coverArt.isImageUrl()) {
            this.setLinked(coverArt.isImageUrl());
            this.setImageUrl(coverArt.getImageUrl());
        } else {
            this.setBinaryData(coverArt.getImageData());
        }
    }

    public static Artwork createArtworkFromMetadataBlockDataPicture(MetadataBlockDataPicture coverArt) {
        Artwork artwork = new Artwork();
        artwork.setFromMetadataBlockDataPicture(coverArt);
        return artwork;
    }
}

