/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoTool;
import org.nuxeo.runtime.api.Framework;

public class VideoWatermarker
extends VideoTool {
    public static final String NAME = "watermarkerTool";
    public static final String WATERMARK_X_POSITION_PARAM = "x";
    public static final String WATERMARK_Y_POSITION_PARAM = "y";
    public static final String WATERMARK_PARAM = "pictureFilePath";
    protected static final String FILTER_COMPLEX_PARAM = "filterComplex";
    protected static final String VIDEO_WATERMARKER_COMMANDLINE = "videoWatermarkWithPicture";

    public VideoWatermarker() {
        super(NAME, VIDEO_WATERMARKER_COMMANDLINE);
    }

    public Map<String, String> setupParameters(BlobHolder input, Map<String, Object> parameters) {
        Map cmdParameters = super.setupParameters(input, parameters);
        Blob video = input.getBlob();
        String x = (String)parameters.get(WATERMARK_X_POSITION_PARAM);
        String y = (String)parameters.get(WATERMARK_Y_POSITION_PARAM);
        Blob watermark = (Blob)parameters.get(WATERMARK_PARAM);
        try {
            String overlay = "overlay=" + x + ":" + y;
            File outputFile = Framework.createTempFile((String)FilenameUtils.removeExtension((String)video.getFilename()), (String)("-WM." + FilenameUtils.getExtension((String)video.getFilename())));
            cmdParameters.put(WATERMARK_PARAM, watermark.getFile().getAbsolutePath());
            cmdParameters.put(FILTER_COMPLEX_PARAM, overlay);
            cmdParameters.put("outFilePath", outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot setup parameters for VideoWatermarker.", (Throwable)e);
        }
        return cmdParameters;
    }
}

