/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ImageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DEPTH = "depth";
    public static final String FORMAT = "format";
    public static final String COLOR_SPACE = "colorSpace";
    protected int width;
    protected int height;
    protected int depth;
    protected String format;
    protected String colorSpace;
    protected String filePath;

    public static ImageInfo fromMap(Map<String, Serializable> map) {
        Long depth;
        Long height;
        if (map == null) {
            return null;
        }
        ImageInfo info = new ImageInfo();
        Long width = (Long)map.get(WIDTH);
        if (width != null) {
            info.width = width.intValue();
        }
        if ((height = (Long)map.get(HEIGHT)) != null) {
            info.height = height.intValue();
        }
        if ((depth = (Long)map.get(DEPTH)) != null) {
            info.depth = depth.intValue();
        }
        info.format = (String)((Object)map.get(FORMAT));
        info.colorSpace = (String)((Object)map.get(COLOR_SPACE));
        return info;
    }

    public ImageInfo() {
    }

    public ImageInfo(String width, String height, String format, String filePath) {
        this.width = Integer.parseInt(width);
        this.height = Integer.parseInt(height);
        this.format = format;
        this.filePath = filePath;
    }

    public ImageInfo(String width, String height, String format, String depth, String filePath) {
        this(width, height, format, filePath);
        this.depth = Integer.parseInt(depth);
    }

    public ImageInfo(String width, String height, String format, String depth, String colorSpace, String filePath) {
        this(width, height, format, filePath);
        this.depth = Integer.parseInt(depth);
        this.colorSpace = colorSpace;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String toString() {
        return this.width + "x" + this.height + "-" + this.format;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public File getFile() {
        return new File(this.filePath);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(WIDTH, Integer.valueOf(this.width));
        map.put(HEIGHT, Integer.valueOf(this.height));
        map.put(DEPTH, Integer.valueOf(this.depth));
        map.put(FORMAT, (Serializable)((Object)this.format));
        map.put(COLOR_SPACE, (Serializable)((Object)this.colorSpace));
        return map;
    }
}

