/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.core;

import java.net.URI;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.DefaultNuxeoUriResolver;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryConfigurationService;
import org.nuxeo.ecm.platform.annotations.service.EventListener;
import org.nuxeo.runtime.api.Framework;

public class AnnotationEventListener
implements EventListener {
    private List<AnnotatedDocumentEventListener> listeners;
    private final DefaultNuxeoUriResolver resolver = new DefaultNuxeoUriResolver();

    public void afterAnnotationCreated(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationCreated(principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    private DocumentLocation getDocumentLocation(Annotation annotation) {
        URI annotates = annotation.getAnnotates();
        return this.resolver.getDocumentLocation(annotates);
    }

    private List<AnnotatedDocumentEventListener> getListeners() {
        if (this.listeners == null) {
            AnnotationsRepositoryConfigurationService service = (AnnotationsRepositoryConfigurationService)Framework.getService(AnnotationsRepositoryConfigurationService.class);
            this.listeners = service.getEventListeners();
        }
        return this.listeners;
    }

    public void afterAnnotationDeleted(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationDeleted(principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void afterAnnotationRead(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationRead(principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void afterAnnotationUpdated(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationUpdated(principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationCreated(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationCreated(principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationDeleted(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationDeleted(principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationRead(NuxeoPrincipal principal, String annotationId) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationRead(principal, annotationId);
        }
    }

    public void beforeAnnotationUpdated(NuxeoPrincipal principal, Annotation annotation) {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationUpdated(principal, this.getDocumentLocation(annotation), annotation);
        }
    }
}

