/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.tools.VideoTool;

public abstract class BaseVideoConversionConverter
extends CommandLineBasedConverter {
    protected static final String OUTPUT_TMP_PATH = "converterTmpPath";

    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> stringSerializableMap) {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        cmdBlobParams.put("inFilePath", blobHolder.getBlob());
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        File outFile;
        HashMap<String, String> cmdStringParams = new HashMap<String, String>();
        String baseDir = this.getTmpDirectory(parameters);
        Path tmpPath = new Path(baseDir).append(this.getTmpDirectoryPrefix() + "_" + UUID.randomUUID());
        File outDir = new File(tmpPath.toString());
        boolean dirCreated = outDir.mkdir();
        if (!dirCreated) {
            throw new ConversionException("Unable to create tmp dir for transformer output: " + outDir);
        }
        try {
            outFile = File.createTempFile("videoConversion", this.getVideoExtension(), outDir);
        }
        catch (IOException e) {
            throw new ConversionException("Unable to get Blob for holder", (Throwable)e);
        }
        try {
            Files.delete(outFile.toPath());
        }
        catch (IOException e) {
            throw new ConversionException("Unable to delete the temporary video conversion file.", (Throwable)e);
        }
        cmdStringParams.put("outFilePath", outFile.getAbsolutePath());
        String baseName = FilenameUtils.getBaseName((String)blobHolder.getBlob().getFilename());
        cmdStringParams.put("outFileName", baseName + this.getVideoExtension());
        VideoInfo videoInfo = (VideoInfo)parameters.get("videoInfo");
        if (videoInfo == null) {
            return cmdStringParams;
        }
        long width = videoInfo.getWidth();
        long height = videoInfo.getHeight();
        long newHeight = (Long)parameters.get("height");
        long newWidth = width * newHeight / height;
        if (newWidth % 2L != 0L) {
            ++newWidth;
        }
        cmdStringParams.put(OUTPUT_TMP_PATH, outDir.getAbsolutePath());
        cmdStringParams.put("width", String.valueOf(newWidth));
        cmdStringParams.put("height", String.valueOf(newHeight));
        return cmdStringParams;
    }

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParameters) {
        String outputPath = cmdParameters.getParameter("outFilePath");
        Blob blob = VideoTool.getTemporaryBlob((String)outputPath, (String)this.getVideoMimeType());
        String outFileName = cmdParameters.getParameter("outFileName");
        if (outFileName != null) {
            blob.setFilename(this.unquoteValue(outFileName));
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>(Collections.singletonList(blob));
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("cmdOutput", (Serializable)((Object)cmdOutput));
        File outDir = new File(cmdParameters.getParameter(OUTPUT_TMP_PATH));
        FileUtils.deleteQuietly((File)outDir);
        return new SimpleBlobHolderWithProperties(blobs, properties);
    }

    protected String unquoteValue(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected abstract String getVideoMimeType();

    protected abstract String getVideoExtension();

    protected abstract String getTmpDirectoryPrefix();
}

