/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.jsonp.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ScriptElement;
import com.google.gwt.jsonp.client.TimeoutException;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class JsonpRequest<T> {
    private static final String CALLBACKS_COUNTER_NAME = "__gwt_jsonp_counter__";
    private static final String CALLBACKS_NAME = "__gwt_jsonp__";
    private static final JavaScriptObject CALLBACKS = JsonpRequest.getOrCreateCallbacksObject();
    private static final String INCREMENTAL_ID_PREFIX = "P";
    private static final String PREDETERMINED_ID_PREFIX = "P";
    private final String callbackId;
    private final int timeout;
    private final AsyncCallback<T> callback;
    private final boolean expectInteger;
    private final String callbackParam;
    private final String failureCallbackParam;
    private final boolean canHaveMultipleRequestsForSameId;
    private Timer timer;

    private static native int getAndIncrementCallbackCounter();

    private static Node getHeadElement() {
        return Document.get().getElementsByTagName("head").getItem(0);
    }

    private static native JavaScriptObject getOrCreateCallbacksObject();

    private static String getPredeterminedId(String suffix) {
        return "P" + suffix;
    }

    private static String nextCallbackId() {
        return "P" + JsonpRequest.getAndIncrementCallbackCounter();
    }

    JsonpRequest(AsyncCallback<T> callback, int timeout, boolean expectInteger, String callbackParam, String failureCallbackParam) {
        this.callbackId = JsonpRequest.nextCallbackId();
        this.callback = callback;
        this.timeout = timeout;
        this.expectInteger = expectInteger;
        this.callbackParam = callbackParam;
        this.failureCallbackParam = failureCallbackParam;
        this.canHaveMultipleRequestsForSameId = false;
    }

    JsonpRequest(AsyncCallback<T> callback, int timeout, boolean expectInteger, String callbackParam, String failureCallbackParam, String id) {
        this.callbackId = JsonpRequest.getPredeterminedId(id);
        this.callback = callback;
        this.timeout = timeout;
        this.expectInteger = expectInteger;
        this.callbackParam = callbackParam;
        this.failureCallbackParam = failureCallbackParam;
        this.canHaveMultipleRequestsForSameId = true;
    }

    public void cancel() {
        this.timer.cancel();
        this.unload();
    }

    public AsyncCallback<T> getCallback() {
        return this.callback;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "JsonpRequest(id=" + this.callbackId + ")";
    }

    String getCallbackId() {
        return this.callbackId;
    }

    void send(final String baseUri) {
        this.registerCallbacks(CALLBACKS, this.canHaveMultipleRequestsForSameId);
        StringBuilder uri = new StringBuilder(baseUri);
        uri.append(baseUri.contains("?") ? "&" : "?");
        String prefix = "__gwt_jsonp__." + this.callbackId;
        uri.append(this.callbackParam).append("=").append(prefix).append(".onSuccess");
        if (this.failureCallbackParam != null) {
            uri.append("&");
            uri.append(this.failureCallbackParam).append("=").append(prefix).append(".onFailure");
        }
        ScriptElement script = Document.get().createScriptElement();
        script.setType("text/javascript");
        script.setId(this.callbackId);
        script.setSrc(uri.toString());
        this.timer = new Timer(){

            @Override
            public void run() {
                JsonpRequest.this.onFailure(new TimeoutException("Timeout while calling " + baseUri));
            }
        };
        this.timer.schedule(this.timeout);
        JsonpRequest.getHeadElement().appendChild(script);
    }

    private void onFailure(String message) {
        this.onFailure(new Exception(message));
    }

    private void onFailure(Throwable ex) {
        this.timer.cancel();
        try {
            if (this.callback != null) {
                this.callback.onFailure(ex);
            }
        }
        finally {
            this.unload();
        }
    }

    private void onSuccess(T data) {
        this.timer.cancel();
        try {
            if (this.callback != null) {
                this.callback.onSuccess(data);
            }
        }
        finally {
            this.unload();
        }
    }

    private native void registerCallbacks(JavaScriptObject var1, boolean var2);

    private void unload() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            @Override
            public void execute() {
                Element script;
                if (!JsonpRequest.this.canHaveMultipleRequestsForSameId) {
                    JsonpRequest.this.unregisterCallbacks(CALLBACKS);
                }
                if ((script = Document.get().getElementById(JsonpRequest.this.callbackId)) != null) {
                    JsonpRequest.getHeadElement().removeChild(script);
                }
            }
        });
    }

    private native void unregisterCallbacks(JavaScriptObject var1);
}

