/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

public class ResizeLayoutPanel
extends SimplePanel
implements ProvidesResize,
HasResizeHandlers {
    private final Impl impl = (Impl)GWT.create(Impl.class);
    private Layout.Layer layer;
    private final Layout layout;
    private final Scheduler.ScheduledCommand resizeCmd = new Scheduler.ScheduledCommand(){

        @Override
        public void execute() {
            ResizeLayoutPanel.this.resizeCmdScheduled = false;
            ResizeLayoutPanel.this.handleResize();
        }
    };
    private boolean resizeCmdScheduled = false;

    public ResizeLayoutPanel() {
        this.layout = new Layout(this.getElement());
        this.impl.init(this.getElement(), new Impl.Delegate(){

            @Override
            public void onResize() {
                ResizeLayoutPanel.this.scheduleResize();
            }
        });
    }

    @Override
    public HandlerRegistration addResizeHandler(ResizeHandler handler) {
        return this.addHandler(handler, ResizeEvent.getType());
    }

    @Override
    public boolean remove(Widget w) {
        if (this.widget != w) {
            return false;
        }
        try {
            this.orphan(w);
        }
        finally {
            this.layout.removeChild(this.layer);
            this.layer = null;
            this.widget = null;
        }
        return true;
    }

    @Override
    public void setWidget(Widget w) {
        if (w == this.widget) {
            return;
        }
        if (w != null) {
            w.removeFromParent();
        }
        if (this.widget != null) {
            this.remove(this.widget);
        }
        this.widget = w;
        if (w != null) {
            this.layer = this.layout.attachChild((Element)this.widget.getElement(), this.widget);
            this.layer.setTopHeight(0.0, Style.Unit.PX, 100.0, Style.Unit.PCT);
            this.layer.setLeftWidth(0.0, Style.Unit.PX, 100.0, Style.Unit.PCT);
            this.adopt(w);
            this.layout.layout();
            this.scheduleResize();
        }
    }

    @Override
    protected void onAttach() {
        super.onAttach();
        this.impl.onAttach();
        this.layout.onAttach();
        this.scheduleResize();
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        this.impl.onDetach();
        this.layout.onDetach();
    }

    private void handleResize() {
        if (!this.isAttached()) {
            return;
        }
        if (this.widget instanceof RequiresResize) {
            ((RequiresResize)((Object)this.widget)).onResize();
        }
        ResizeEvent.fire(this, this.getOffsetWidth(), this.getOffsetHeight());
    }

    private void scheduleResize() {
        if (this.isAttached() && !this.resizeCmdScheduled) {
            this.resizeCmdScheduled = true;
            Scheduler.get().scheduleDeferred(this.resizeCmd);
        }
    }

    static class ImplTrident
    extends Impl {
        ImplTrident() {
        }

        @Override
        public void init(Element elem, Impl.Delegate delegate) {
            super.init(elem, delegate);
            this.initResizeEventListener(elem);
        }

        @Override
        public void onAttach() {
            super.onAttach();
            this.setResizeEventListener(this.parent, this);
        }

        @Override
        public void onDetach() {
            super.onDetach();
            this.setResizeEventListener(this.parent, null);
        }

        private native void initResizeEventListener(Element var1);

        private native void setResizeEventListener(Element var1, Impl var2);
    }

    static class ImplStandard
    extends Impl
    implements EventListener {
        private static final String MIN_SIZE = "20px";
        private Element collapsible;
        private Element collapsibleInner;
        private Element expandable;
        private Element expandableInner;
        private int lastOffsetHeight = -1;
        private int lastOffsetWidth = -1;
        private boolean resettingScrollables;

        ImplStandard() {
        }

        @Override
        public void init(Element elem, Impl.Delegate delegate) {
            super.init(elem, delegate);
            elem.getStyle().setProperty("minWidth", MIN_SIZE);
            elem.getStyle().setProperty("minHeight", MIN_SIZE);
            this.expandable = (Element)Document.get().createDivElement().cast();
            this.expandable.getStyle().setVisibility(Style.Visibility.HIDDEN);
            this.expandable.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.expandable.getStyle().setHeight(100.0, Style.Unit.PCT);
            this.expandable.getStyle().setWidth(100.0, Style.Unit.PCT);
            this.expandable.getStyle().setOverflow(Style.Overflow.SCROLL);
            this.expandable.getStyle().setZIndex(-1);
            elem.appendChild(this.expandable);
            this.expandableInner = (Element)Document.get().createDivElement().cast();
            this.expandable.appendChild(this.expandableInner);
            DOM.sinkEvents(this.expandable, 16384);
            this.collapsible = (Element)Document.get().createDivElement().cast();
            this.collapsible.getStyle().setVisibility(Style.Visibility.HIDDEN);
            this.collapsible.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.collapsible.getStyle().setHeight(100.0, Style.Unit.PCT);
            this.collapsible.getStyle().setWidth(100.0, Style.Unit.PCT);
            this.collapsible.getStyle().setOverflow(Style.Overflow.SCROLL);
            this.collapsible.getStyle().setZIndex(-1);
            elem.appendChild(this.collapsible);
            this.collapsibleInner = (Element)Document.get().createDivElement().cast();
            this.collapsibleInner.getStyle().setWidth(200.0, Style.Unit.PCT);
            this.collapsibleInner.getStyle().setHeight(200.0, Style.Unit.PCT);
            this.collapsible.appendChild(this.collapsibleInner);
            DOM.sinkEvents(this.collapsible, 16384);
        }

        @Override
        public void onAttach() {
            super.onAttach();
            DOM.setEventListener(this.expandable, this);
            DOM.setEventListener(this.collapsible, this);
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                @Override
                public void execute() {
                    ImplStandard.this.resetScrollables();
                }
            });
        }

        @Override
        public void onBrowserEvent(Event event) {
            if (!this.resettingScrollables && 16384 == event.getTypeInt()) {
                EventTarget eventTarget = event.getEventTarget();
                if (!Element.is(eventTarget)) {
                    return;
                }
                Element target = (Element)eventTarget.cast();
                if (target == this.collapsible || target == this.expandable) {
                    this.handleResize();
                }
            }
        }

        @Override
        public void onDetach() {
            super.onDetach();
            DOM.setEventListener(this.expandable, null);
            DOM.setEventListener(this.collapsible, null);
            this.lastOffsetHeight = -1;
            this.lastOffsetWidth = -1;
        }

        @Override
        protected void handleResize() {
            if (this.resetScrollables()) {
                super.handleResize();
            }
        }

        private boolean resetScrollables() {
            if (this.resettingScrollables) {
                return false;
            }
            this.resettingScrollables = true;
            int offsetHeight = this.parent.getOffsetHeight();
            int offsetWidth = this.parent.getOffsetWidth();
            int height = offsetHeight + 100;
            int width = offsetWidth + 100;
            this.expandableInner.getStyle().setHeight(height, Style.Unit.PX);
            this.expandableInner.getStyle().setWidth(width, Style.Unit.PX);
            this.expandable.setScrollTop(height);
            this.expandable.setScrollLeft(width);
            this.collapsible.setScrollTop(this.collapsible.getScrollHeight() + 100);
            this.collapsible.setScrollLeft(this.collapsible.getScrollWidth() + 100);
            if (this.lastOffsetHeight != offsetHeight || this.lastOffsetWidth != offsetWidth) {
                this.lastOffsetHeight = offsetHeight;
                this.lastOffsetWidth = offsetWidth;
                this.resettingScrollables = false;
                return true;
            }
            this.resettingScrollables = false;
            return false;
        }
    }

    static abstract class Impl {
        boolean isAttached;
        Element parent;
        private Delegate delegate;

        Impl() {
        }

        public void init(Element elem, Delegate delegate) {
            this.parent = elem;
            this.delegate = delegate;
        }

        public void onAttach() {
            this.isAttached = true;
        }

        public void onDetach() {
            this.isAttached = false;
        }

        protected void handleResize() {
            if (this.isAttached && this.delegate != null) {
                this.delegate.onResize();
            }
        }

        static interface Delegate {
            public void onResize();
        }
    }
}

