/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

public class ConvertToPDFPictureConverter
implements Converter {
    private static final Log log = LogFactory.getLog(ConvertToPDFPictureConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        ImagingService service = (ImagingService)Framework.getService(ImagingService.class);
        List sources = blobHolder.getBlobs();
        ArrayList results = new ArrayList(sources.size());
        sources.stream().filter(source -> source != null).forEach(source -> {
            Blob result = service.convertToPDF(source);
            if (result != null) {
                results.add(result);
            }
        });
        return new SimpleCachableBlobHolder(results);
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

