/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingCacheGCManager;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingComponent;
import org.nuxeo.runtime.api.Framework;

public class GCTask
implements Runnable {
    protected static volatile boolean GCEnabled = false;
    private static final String GCINTERVAL_KEY = "GCInterval";
    private static long GC_INTERVAL = 0L;
    private static final Log log = LogFactory.getLog(GCTask.class);

    public static long getGCIntervalInMinutes() {
        if (GC_INTERVAL == 0L) {
            PictureTilingComponent ptc = (PictureTilingComponent)Framework.getService(PictureTilingService.class);
            GC_INTERVAL = Long.parseLong(ptc.getEnvValue(GCINTERVAL_KEY, Long.toString(10L)));
            log.debug((Object)("GC interval set to " + GC_INTERVAL));
        }
        return GC_INTERVAL;
    }

    public static void setGCIntervalInMinutes(long interval) {
        GC_INTERVAL = interval;
    }

    @Override
    public void run() {
        log.debug((Object)"starting GC thread");
        while (GCEnabled) {
            PictureTilingCacheGCManager.gcIfNeeded();
            try {
                long gcInterval = GCTask.getGCIntervalInMinutes();
                if (gcInterval < 0L) {
                    log.debug((Object)("GC sleeps for " + -gcInterval));
                    Thread.sleep(-gcInterval);
                    continue;
                }
                log.debug((Object)("GC sleeps for " + gcInterval * 60L * 1000L));
                Thread.sleep(gcInterval * 60L * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                GCEnabled = false;
            }
        }
    }
}

