/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import java.util.HashMap;
import java.util.Map;

public class DockLayoutPanelParser
implements ElementParser {
    private static final Map<String, String> DOCK_NAMES = new HashMap<String, String>();

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        if (type != this.getSplitLayoutPanelType(writer)) {
            JEnumType unitEnumType = writer.getOracle().findType(Style.Unit.class.getCanonicalName()).isEnum();
            String unit = elem.consumeAttributeWithDefault("unit", String.format("%s.%s", unitEnumType.getQualifiedSourceName(), "PX"), (JType)unitEnumType);
            writer.setFieldInitializerAsConstructor(fieldName, new String[]{unit});
        }
        CenterChild center = null;
        for (XMLElement child : elem.consumeChildElements()) {
            XMLElement widget;
            if (!this.isValidChildElement(elem, child)) {
                writer.die(elem, "Child must be one of <%1$s:north>, <%1$s:south>, <%1$s:east>, <%1$s:west> or <%1$s:center>, but found %2$s", new Object[]{elem.getPrefix(), child});
            }
            if (!writer.isWidgetElement(widget = child.consumeSingleChildElement())) {
                writer.die(elem, "%s must contain a widget, but found %s", new Object[]{child, widget});
            }
            FieldWriter widgetField = writer.parseElementToField(widget);
            if (child.getLocalName().equals("center")) {
                if (center != null) {
                    writer.die(elem, "Only one <%s:center> is allowed", new Object[]{elem.getPrefix()});
                }
                center = new CenterChild(child, widgetField.getNextReference());
                continue;
            }
            String size = child.consumeRequiredDoubleAttribute("size");
            writer.addStatement("%s.%s(%s, %s);", new Object[]{fieldName, this.addMethodName(child), widgetField.getNextReference(), size});
        }
        if (center != null) {
            writer.addStatement("%s.%s(%s);", new Object[]{fieldName, this.addMethodName(center.child), center.widgetName});
        }
    }

    private String addMethodName(XMLElement elem) {
        return DOCK_NAMES.get(elem.getLocalName());
    }

    private JClassType getSplitLayoutPanelType(UiBinderWriter writer) {
        try {
            return writer.getOracle().getType(SplitLayoutPanel.class.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private boolean isValidChildElement(XMLElement parent, XMLElement child) {
        if (!parent.getNamespaceUri().equals(child.getNamespaceUri())) {
            return false;
        }
        return DOCK_NAMES.containsKey(child.getLocalName());
    }

    static {
        DOCK_NAMES.put("north", "addNorth");
        DOCK_NAMES.put("south", "addSouth");
        DOCK_NAMES.put("east", "addEast");
        DOCK_NAMES.put("west", "addWest");
        DOCK_NAMES.put("lineStart", "addLineStart");
        DOCK_NAMES.put("lineEnd", "addLineEnd");
        DOCK_NAMES.put("center", "add");
    }

    private static class CenterChild {
        final String widgetName;
        final XMLElement child;

        public CenterChild(XMLElement child, String widgetName) {
            this.widgetName = widgetName;
            this.child = child;
        }
    }
}

