/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoTool;
import org.nuxeo.runtime.api.Framework;

public class VideoConcat
extends VideoTool {
    public static final String NAME = "concatTool";
    protected static final String VIDEOS_FILE_PATH_PARAM = "listFilePath";
    protected static final String VIDEO_CONCAT_COMMANDLINE = "videoConcat";

    public VideoConcat() {
        super(NAME, VIDEO_CONCAT_COMMANDLINE);
    }

    public Map<String, String> setupParameters(BlobHolder blobHolder, Map<String, Object> parameters) {
        List videos = blobHolder.getBlobs();
        ArrayList<File> sourceFiles = new ArrayList<File>();
        try {
            ArrayList<String> lines = new ArrayList<String>();
            for (Blob b : videos) {
                File blobFile = b.getFile();
                sourceFiles.add(blobFile);
                lines.add("file '" + blobFile.getAbsolutePath());
            }
            File tempFile = Framework.createTempFile((String)"NxVTcv-", (String)".txt");
            Files.write(tempFile.toPath(), lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            if (blobHolder.getBlobs().size() < 2) {
                throw new NuxeoException("VideoConcat requires at least two videos to proceed.");
            }
            Blob firstVideo = (Blob)blobHolder.getBlobs().get(0);
            String outputFilename = firstVideo.getFilename();
            File outputFile = Framework.createTempFile((String)FilenameUtils.removeExtension((String)outputFilename), (String)("-concat." + FilenameUtils.getExtension((String)outputFilename)));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(VIDEOS_FILE_PATH_PARAM, tempFile.getAbsolutePath());
            params.put("outFilePath", outputFile.getAbsolutePath());
            return params;
        }
        catch (IOException e) {
            throw new NuxeoException("VideoConcat could not prepare the parameters.", (Throwable)e);
        }
    }

    public void cleanupInputs(Map<String, String> parameters) {
        String path = parameters.get(VIDEOS_FILE_PATH_PARAM);
        FileUtils.deleteQuietly((File)new File(path));
    }
}

