/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.operation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.picture.recompute.ImagingRecomputeWork;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Picture.RecomputeViews", category="Services", label="Recompute Picture Views", description="Recompute the picture views of the documents resulting from the provided NXQL query.", since="10.3")
public class RecomputePictureViews {
    public static final String ID = "Picture.RecomputeViews";
    public static final String DEFAULT_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL";
    @Context
    protected CoreSession session;
    @Param(name="query", description="NXQL query to collect the documents whose picture views to recompute.", values={"SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL"})
    protected String query;

    @OperationMethod
    public void run() {
        ImagingRecomputeWork work = new ImagingRecomputeWork(this.session.getRepositoryName(), this.query);
        ((WorkManager)Framework.getService(WorkManager.class)).schedule((Work)work);
    }
}

