/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.thumbnail;

import java.io.File;
import java.io.IOException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ThumbnailPictureFactory
implements ThumbnailFactory {
    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        if (!doc.hasFacet("Picture")) {
            throw new NuxeoException("Document is not a picture");
        }
        MultiviewPicture mViewPicture = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class);
        PictureView thumbnailView = mViewPicture.getView("Small");
        if (!(thumbnailView != null && thumbnailView.getBlob() != null || (thumbnailView = mViewPicture.getView("Thumbnail")) != null && thumbnailView.getBlob() != null)) {
            TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
            try {
                return Blobs.createBlob((File)FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return thumbnailView.getBlob();
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        return null;
    }
}

