/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.listeners;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.AbstractLongRunningListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.platform.scanner.dlp.DataLossPreventionScanner;
import org.nuxeo.platform.scanner.dlp.listeners.DLPScanEventContext;
import org.nuxeo.platform.scanner.dlp.service.ScanFinding;
import org.nuxeo.platform.scanner.dlp.service.ScanResult;
import org.nuxeo.runtime.api.Framework;

public class DLPScannerProcessor
extends AbstractLongRunningListener {
    public boolean acceptEvent(Event event) {
        return "dlpScanNeeded".equals(event.getName());
    }

    protected boolean handleEventPreprocessing(EventBundle events, Map<String, Object> data) {
        for (Event event : events) {
            DLPScanEventContext vContext;
            DocumentModel doc;
            if (!"dlpScanNeeded".equals(event.getName()) || (doc = (vContext = DLPScanEventContext.unwrap((DocumentEventContext)event.getContext())).getSourceDocument()).isVersion() || doc.isImmutable()) continue;
            String key = doc.getRepositoryName() + ":" + doc.getId();
            HashMap<String, Blob> blobs = (HashMap<String, Blob>)data.get(key);
            if (blobs == null) {
                blobs = new HashMap<String, Blob>();
            }
            for (String path : vContext.getBlobPaths()) {
                blobs.put(path, (Blob)doc.getPropertyValue(path));
            }
            data.put(key, blobs);
        }
        return data.size() > 0;
    }

    protected boolean handleEventLongRunning(List<String> eventNames, Map<String, Object> data) {
        boolean doContinue = false;
        DataLossPreventionScanner scanService = (DataLossPreventionScanner)Framework.getService(DataLossPreventionScanner.class);
        for (String key : data.keySet()) {
            Map blobs = (Map)data.get(key);
            HashMap<String, ScanResult> results = new HashMap<String, ScanResult>();
            for (String path : blobs.keySet()) {
                try {
                    results.put(path, scanService.identify((Blob)blobs.get(path)));
                    doContinue = true;
                }
                catch (Exception e) {
                    log.error((Object)"Error calling ScanProvider", (Throwable)e);
                    results.put(path, ScanResult.makeFailed());
                }
            }
            data.put(key, results);
        }
        return doContinue;
    }

    protected void handleEventPostprocessing(EventBundle events, Map<String, Object> data) {
        for (Event event : events) {
            if (!"dlpScanNeeded".equals(event.getName())) continue;
            DLPScanEventContext vContext = DLPScanEventContext.unwrap((DocumentEventContext)event.getContext());
            DocumentModel doc = vContext.getSourceDocument();
            String key = doc.getRepositoryName() + ":" + doc.getId();
            Map results = (Map)data.get(key);
            Property findingProp = doc.getProperty("dlp:findings");
            boolean failed = false;
            boolean sensitive = false;
            if (results != null && results.size() > 0) {
                for (String path : results.keySet()) {
                    ScanResult res = (ScanResult)results.get(path);
                    if (res == null) continue;
                    if (res.hasSensitiveData()) {
                        sensitive = true;
                    }
                    if (res.isError()) {
                        failed = true;
                    }
                    if (res.getFindings() == null) continue;
                    findingProp.remove();
                    for (ScanFinding f : res.getFindings()) {
                        HashMap<String, String> fmap = new HashMap<String, String>();
                        fmap.put("info", f.getInfo());
                        fmap.put("score", f.getScore());
                        fmap.put("type", f.getType());
                        findingProp.addValue(fmap);
                    }
                }
            }
            doc.setPropertyValue("dlp:sensitiveData", (Serializable)Boolean.valueOf(sensitive));
            doc.setPropertyValue("dlp:scanDate", (Serializable)new Date());
            doc.setPropertyValue("dlp:scanStatus", (Serializable)((Object)(failed ? "failed" : "done")));
            doc.putContextData("disableDLPScanListener", (Serializable)Boolean.valueOf(true));
            CoreSession session = doc.getCoreSession();
            session.saveDocument(doc);
            if (!sensitive) continue;
            EventService eventService = (EventService)Framework.getService(EventService.class);
            DocumentEventContext dctx = new DocumentEventContext(session, session.getPrincipal(), doc, vContext.getDestination());
            eventService.fireEvent(dctx.newEvent("dlpSensitiveDataFound"));
        }
    }
}

