/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.google;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.util.PDFMergerUtility;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.platform.scanner.dlp.DataLossPreventionScanner;
import org.nuxeo.runtime.api.Framework;

public class GoogleRenditionProvider
implements RenditionProvider {
    protected static final Log log = LogFactory.getLog(GoogleRenditionProvider.class);
    static final String IMAGE_VARIANT = "image";
    static final String DOC_VARIANT = "document";
    private DataLossPreventionScanner dlpService;

    private DataLossPreventionScanner dlp() {
        if (this.dlpService == null) {
            this.dlpService = (DataLossPreventionScanner)Framework.getService(DataLossPreventionScanner.class);
        }
        return this.dlpService;
    }

    public boolean isAvailable(DocumentModel doc, RenditionDefinition definition) {
        return Boolean.parseBoolean(Framework.getProperty((String)"google.dlp.enabled", (String)"true"));
    }

    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) {
        BlobHolder input = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob output = null;
        output = IMAGE_VARIANT.equals(definition.getVariantPolicy()) ? this.redactImage(input.getBlob(), null) : this.redactDocument(input, null);
        if (output == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(output);
    }

    public Blob redact(DocumentModel doc, List<String> features) {
        BlobHolder input = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob output = null;
        output = doc.hasFacet("Picture") ? this.redactImage(input.getBlob(), features) : this.redactDocument(input, features);
        if (output == null) {
            return null;
        }
        return output;
    }

    public Blob redact(Blob blob, List<String> features) {
        Blob data = this.dlp().redact(blob, features);
        if (data.getMimeType() == null) {
            MimetypeRegistry reg = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            data.setMimeType(reg.getMimetypeFromBlob(data));
        }
        return data;
    }

    public Blob redactImage(Blob input, List<String> features) {
        return this.redact(input, features);
    }

    public Blob redactDocument(BlobHolder input, List<String> features) {
        ConversionService conv = (ConversionService)Framework.getService(ConversionService.class);
        if (!"application/pdf".equals(input.getBlob().getMimeType())) {
            input = conv.convertToMimeType("application/pdf", input, Collections.emptyMap());
        }
        BlobHolder images = conv.convert("pdf2hiResImage", input, Collections.singletonMap("targetFilePath", "conversion_%04d.png"));
        ArrayList<Blob> parts = new ArrayList<Blob>(images.getBlobs().size());
        for (Blob img : images.getBlobs()) {
            Blob out = this.redact(img, features);
            BlobHolder toPdf = conv.convert("image2pdf", (BlobHolder)new SimpleBlobHolder(out), Collections.emptyMap());
            parts.add(toPdf.getBlob());
        }
        Collections.sort(parts, new Comparator<Blob>(){

            @Override
            public int compare(Blob o1, Blob o2) {
                return o1.getFilename().compareTo(o2.getFilename());
            }
        });
        try {
            PDFMergerUtility ut = new PDFMergerUtility();
            for (Blob blob : parts) {
                ut.addSource(blob.getStream());
            }
            return this.appendPDFs(ut, input.getBlob().getFilename());
        }
        catch (IOException | COSVisitorException iox) {
            throw new NuxeoException(iox);
        }
    }

    protected Blob appendPDFs(PDFMergerUtility ut, String filename) throws IOException, COSVisitorException {
        File tempFile = Framework.createTempFile((String)("redacted_" + filename), (String)".pdf");
        ut.setDestinationFileName(tempFile.getAbsolutePath());
        ut.mergeDocuments();
        Blob fb = Blobs.createBlob((File)tempFile);
        Framework.trackFile((File)tempFile, (Object)fb);
        fb.setFilename(tempFile.getName());
        return fb;
    }
}

