/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.listeners;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.platform.scanner.dlp.listeners.DLPScanEventContext;
import org.nuxeo.runtime.api.Framework;

public class DLPScanSyncListener
implements EventListener {
    protected static final Log log = LogFactory.getLog(DLPScanSyncListener.class);
    Boolean enabled;

    private boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = Boolean.parseBoolean(Framework.getProperty((String)"dlp.scan.enabled", (String)"true"));
        }
        return this.enabled;
    }

    public void handleEvent(Event event) {
        if (this.isEnabled() && event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel targetDoc = docCtx.getSourceDocument();
            Boolean block = (Boolean)event.getContext().getProperty("disableDLPScanListener");
            if (block != null && block.booleanValue()) {
                return;
            }
            if (targetDoc == null) {
                return;
            }
            List<String> propertiesPath = null;
            if ("aboutToCreate".equals(event.getName())) {
                this.markDocumentForScaning(targetDoc);
            } else if ("documentCreated".equals(event.getName())) {
                propertiesPath = this.getBlobsXPath(targetDoc, false);
            } else if ("beforeDocumentModification".equals(event.getName())) {
                propertiesPath = this.getBlobsXPath(targetDoc, true);
                this.markDocumentForScaning(targetDoc);
            }
            if (propertiesPath != null && propertiesPath.size() > 0) {
                DLPScanEventContext dlpScanCtx = new DLPScanEventContext(docCtx, propertiesPath);
                EventService eventService = (EventService)Framework.getService(EventService.class);
                eventService.fireEvent(dlpScanCtx.newDLPScanEvent());
            }
        }
    }

    protected void markDocumentForScaning(DocumentModel doc) {
        if (!doc.hasFacet("DataLossPrevention")) {
            doc.addFacet("DataLossPrevention");
        }
        doc.setPropertyValue("dlp:scanStatus", (Serializable)((Object)"pending"));
    }

    protected List<String> getBlobsXPath(DocumentModel doc, boolean onlyChangedBlob) {
        ArrayList<String> propertiesPath = new ArrayList<String>();
        BlobsExtractor extractor = new BlobsExtractor();
        List blobProperties = extractor.getBlobsProperties(doc);
        for (Property prop : blobProperties) {
            if (onlyChangedBlob) {
                if (!prop.isDirty()) continue;
                propertiesPath.add(prop.getXPath());
                continue;
            }
            propertiesPath.add(prop.getXPath());
        }
        return propertiesPath;
    }
}

