/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FileStoreDataProfileName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_FILE_STORE_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}");
    private static final PathTemplate PROJECT_LOCATION_FILE_STORE_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String fileStoreDataProfile;
    private final String project;

    @Deprecated
    protected FileStoreDataProfileName() {
        this.organization = null;
        this.location = null;
        this.fileStoreDataProfile = null;
        this.project = null;
    }

    private FileStoreDataProfileName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.fileStoreDataProfile = (String)Preconditions.checkNotNull((Object)builder.getFileStoreDataProfile());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_FILE_STORE_DATA_PROFILE;
    }

    private FileStoreDataProfileName(ProjectLocationFileStoreDataProfileBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.fileStoreDataProfile = (String)Preconditions.checkNotNull((Object)builder.getFileStoreDataProfile());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_FILE_STORE_DATA_PROFILE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFileStoreDataProfile() {
        return this.fileStoreDataProfile;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationFileStoreDataProfileBuilder() {
        return new Builder();
    }

    public static ProjectLocationFileStoreDataProfileBuilder newProjectLocationFileStoreDataProfileBuilder() {
        return new ProjectLocationFileStoreDataProfileBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FileStoreDataProfileName of(String organization, String location, String fileStoreDataProfile) {
        return FileStoreDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setFileStoreDataProfile(fileStoreDataProfile).build();
    }

    public static FileStoreDataProfileName ofOrganizationLocationFileStoreDataProfileName(String organization, String location, String fileStoreDataProfile) {
        return FileStoreDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setFileStoreDataProfile(fileStoreDataProfile).build();
    }

    public static FileStoreDataProfileName ofProjectLocationFileStoreDataProfileName(String project, String location, String fileStoreDataProfile) {
        return FileStoreDataProfileName.newProjectLocationFileStoreDataProfileBuilder().setProject(project).setLocation(location).setFileStoreDataProfile(fileStoreDataProfile).build();
    }

    public static String format(String organization, String location, String fileStoreDataProfile) {
        return FileStoreDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setFileStoreDataProfile(fileStoreDataProfile).build().toString();
    }

    public static String formatOrganizationLocationFileStoreDataProfileName(String organization, String location, String fileStoreDataProfile) {
        return FileStoreDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setFileStoreDataProfile(fileStoreDataProfile).build().toString();
    }

    public static String formatProjectLocationFileStoreDataProfileName(String project, String location, String fileStoreDataProfile) {
        return FileStoreDataProfileName.newProjectLocationFileStoreDataProfileBuilder().setProject(project).setLocation(location).setFileStoreDataProfile(fileStoreDataProfile).build().toString();
    }

    public static FileStoreDataProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_FILE_STORE_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_FILE_STORE_DATA_PROFILE.match(formattedString);
            return FileStoreDataProfileName.ofOrganizationLocationFileStoreDataProfileName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("file_store_data_profile"));
        }
        if (PROJECT_LOCATION_FILE_STORE_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_FILE_STORE_DATA_PROFILE.match(formattedString);
            return FileStoreDataProfileName.ofProjectLocationFileStoreDataProfileName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("file_store_data_profile"));
        }
        throw new ValidationException("FileStoreDataProfileName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FileStoreDataProfileName> parseList(List<String> formattedStrings) {
        ArrayList<FileStoreDataProfileName> list = new ArrayList<FileStoreDataProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FileStoreDataProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FileStoreDataProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FileStoreDataProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_FILE_STORE_DATA_PROFILE.matches(formattedString) || PROJECT_LOCATION_FILE_STORE_DATA_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FileStoreDataProfileName fileStoreDataProfileName = this;
            synchronized (fileStoreDataProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.fileStoreDataProfile != null) {
                        fieldMapBuilder.put((Object)"file_store_data_profile", (Object)this.fileStoreDataProfile);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FileStoreDataProfileName that = (FileStoreDataProfileName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.fileStoreDataProfile, that.fileStoreDataProfile) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.fileStoreDataProfile);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationFileStoreDataProfileBuilder {
        private String project;
        private String location;
        private String fileStoreDataProfile;

        protected ProjectLocationFileStoreDataProfileBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFileStoreDataProfile() {
            return this.fileStoreDataProfile;
        }

        public ProjectLocationFileStoreDataProfileBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationFileStoreDataProfileBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationFileStoreDataProfileBuilder setFileStoreDataProfile(String fileStoreDataProfile) {
            this.fileStoreDataProfile = fileStoreDataProfile;
            return this;
        }

        public FileStoreDataProfileName build() {
            return new FileStoreDataProfileName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String fileStoreDataProfile;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFileStoreDataProfile() {
            return this.fileStoreDataProfile;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFileStoreDataProfile(String fileStoreDataProfile) {
            this.fileStoreDataProfile = fileStoreDataProfile;
            return this;
        }

        private Builder(FileStoreDataProfileName fileStoreDataProfileName) {
            Preconditions.checkArgument((boolean)Objects.equals(fileStoreDataProfileName.pathTemplate, ORGANIZATION_LOCATION_FILE_STORE_DATA_PROFILE), (Object)"toBuilder is only supported when FileStoreDataProfileName has the pattern of organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}");
            this.organization = fileStoreDataProfileName.organization;
            this.location = fileStoreDataProfileName.location;
            this.fileStoreDataProfile = fileStoreDataProfileName.fileStoreDataProfile;
        }

        public FileStoreDataProfileName build() {
            return new FileStoreDataProfileName(this);
        }
    }
}

