/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.google;

import com.google.cloud.ServiceOptions;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.cloud.dlp.v2.DlpServiceSettings;
import com.google.privacy.dlp.v2.BoundingBox;
import com.google.privacy.dlp.v2.ByteContentItem;
import com.google.privacy.dlp.v2.ContentItem;
import com.google.privacy.dlp.v2.ContentLocation;
import com.google.privacy.dlp.v2.CreateInspectTemplateRequest;
import com.google.privacy.dlp.v2.CustomInfoType;
import com.google.privacy.dlp.v2.Finding;
import com.google.privacy.dlp.v2.ImageLocation;
import com.google.privacy.dlp.v2.InfoType;
import com.google.privacy.dlp.v2.InfoTypeDescription;
import com.google.privacy.dlp.v2.InspectConfig;
import com.google.privacy.dlp.v2.InspectContentRequest;
import com.google.privacy.dlp.v2.InspectContentResponse;
import com.google.privacy.dlp.v2.InspectResult;
import com.google.privacy.dlp.v2.InspectTemplate;
import com.google.privacy.dlp.v2.Likelihood;
import com.google.privacy.dlp.v2.ListInfoTypesRequest;
import com.google.privacy.dlp.v2.ListInfoTypesResponse;
import com.google.privacy.dlp.v2.Location;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.RedactImageRequest;
import com.google.privacy.dlp.v2.RedactImageResponse;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.platform.scanner.dlp.google.GoogleDLPConstants;
import org.nuxeo.platform.scanner.dlp.google.GoogleRenditionProvider;
import org.nuxeo.platform.scanner.dlp.service.RedactionProvider;
import org.nuxeo.platform.scanner.dlp.service.ScanFinding;
import org.nuxeo.platform.scanner.dlp.service.ScanProvider;
import org.nuxeo.platform.scanner.dlp.service.ScanResult;
import org.nuxeo.runtime.api.Framework;

public class GoogleDLPScanProvider
implements RedactionProvider,
ScanProvider,
GoogleDLPConstants {
    protected static final Logger log = LogManager.getLogger(GoogleDLPScanProvider.class);
    Likelihood likelihood = Likelihood.LIKELY;
    Likelihood sensitivity = Likelihood.LIKELY;
    private int maxFindings = 5;
    private boolean enabled = true;
    private boolean convertToText = true;
    private boolean includeQuote = true;
    private String projectId = null;
    private DlpServiceSettings dlpServiceSettings = null;
    private List<InfoType> infoTypesList = null;
    private List<CustomInfoType> customInfoTypesList = null;
    private GoogleRenditionProvider renditionProvider = new GoogleRenditionProvider();

    public GoogleDLPScanProvider() {
        this.init();
    }

    private void init() {
        String infoTypeStr;
        String maxFindingsStr;
        try {
            this.dlpServiceSettings = DlpServiceSettings.newBuilder().build();
        }
        catch (IOException iox) {
            log.error("Error loading Google Authentication Credentials", (Throwable)iox);
            log.error("Data Loss Prevention scanning will be unavailable");
            this.enabled = false;
            return;
        }
        this.projectId = Framework.getProperty((String)"google.dlp.api.project", (String)ServiceOptions.getDefaultProjectId());
        this.enabled = Boolean.parseBoolean(Framework.getProperty((String)"google.dlp.enabled", (String)"true"));
        this.includeQuote = Boolean.parseBoolean(Framework.getProperty((String)"google.dlp.quote", (String)"true"));
        this.convertToText = Boolean.parseBoolean(Framework.getProperty((String)"google.dlp.convert", (String)"true"));
        String likelihoodStr = Framework.getProperty((String)"google.dlp.likelyhood", (String)DEFAULT_LIKELYHOOD);
        if (StringUtils.isNotBlank((CharSequence)likelihoodStr)) {
            try {
                this.likelihood = Likelihood.valueOf((String)likelihoodStr);
            }
            catch (NumberFormatException nfe) {
                log.error("google.dlp.likelyhood is not one of: " + Arrays.asList(Likelihood.values()));
            }
        }
        String sensitivityStr = Framework.getProperty((String)"google.dlp.sensitivity", (String)DEFAULT_LIKELYHOOD);
        if (StringUtils.isNotBlank((CharSequence)likelihoodStr)) {
            try {
                this.sensitivity = Likelihood.valueOf((String)sensitivityStr);
            }
            catch (NumberFormatException nfe) {
                log.error("google.dlp.sensitivity is not one of: " + Arrays.asList(Likelihood.values()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(maxFindingsStr = Framework.getProperty((String)"google.dlp.maxfindings", (String)"5")))) {
            try {
                this.maxFindings = Integer.parseInt(maxFindingsStr);
            }
            catch (NumberFormatException nfe) {
                log.error("google.dlp.maxfindings is not a number");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(infoTypeStr = Framework.getProperty((String)"google.dlp.infotypes", (String)"CREDIT_CARD_NUMBER,IBAN_CODE,SWIFT_CODE,US_SOCIAL_SECURITY_NUMBER,US_PASSPORT,US_INDIVIDUAL_TAXPAYER_IDENTIFICATION_NUMBER,US_EMPLOYER_IDENTIFICATION_NUMBER,US_BANK_ROUTING_MICR")))) {
            String[] infoTypes;
            this.infoTypesList = new ArrayList<InfoType>();
            for (String infoType : infoTypes = infoTypeStr.split(",")) {
                this.infoTypesList.add(InfoType.newBuilder().setName(infoType).build());
            }
        } else {
            this.infoTypesList = Collections.emptyList();
        }
        this.customInfoTypesList = Collections.emptyList();
    }

    @Override
    public boolean supportsRedaction() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.dlpServiceSettings != null;
    }

    @Override
    public boolean checkBlobs(List<Blob> blobs) {
        return true;
    }

    @Override
    public List<ScanResult> identify(List<Blob> blobs, List<String> features, Integer maxResults) throws IOException {
        return blobs.stream().map(b -> this.inspect((Blob)b, features, maxResults)).collect(Collectors.toList());
    }

    protected ScanResult inspect(Blob blob, List<String> features, Integer maxResults) {
        if (!this.isEnabled()) {
            return ScanResult.makeFailed();
        }
        if (blob != null && (blob.getLength() == -1L || blob.getLength() > 0L)) {
            return this.inspectBlob(blob, features, maxResults);
        }
        return new ScanResult(Collections.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ScanResult inspectBlob(Blob blob, List<String> features, Integer maxResults) {
        LinkedList<ScanFinding> findings = new LinkedList<ScanFinding>();
        try {
            DlpServiceClient dlpServiceClient = DlpServiceClient.create((DlpServiceSettings)this.dlpServiceSettings);
            try {
                ByteString bytes;
                String mimeType = blob.getMimeType();
                if (mimeType == null) {
                    mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(blob.getFile());
                }
                if (this.convertToText && (mimeType == null || !mimeType.startsWith("text") && !mimeType.startsWith("image"))) {
                    try {
                        ConversionService conv = (ConversionService)Framework.getService(ConversionService.class);
                        String text = conv.convertToMimeType("text/plain", (BlobHolder)new SimpleBlobHolder(blob), Collections.emptyMap());
                        blob = text.getBlob();
                    }
                    catch (ConversionException cex) {
                        log.warn("Unable to scan for DLP: " + cex.getMessage());
                        ScanResult text = ScanResult.makeFailed();
                        if (dlpServiceClient == null) return text;
                        dlpServiceClient.close();
                        return text;
                    }
                }
                ByteContentItem.BytesType bytesType = switch (mimeType) {
                    case "image/jpeg" -> ByteContentItem.BytesType.IMAGE_JPEG;
                    case "image/bmp" -> ByteContentItem.BytesType.IMAGE_BMP;
                    case "image/png" -> ByteContentItem.BytesType.IMAGE_PNG;
                    case "image/svg" -> ByteContentItem.BytesType.IMAGE_SVG;
                    default -> ByteContentItem.BytesType.BYTES_TYPE_UNSPECIFIED;
                };
                List<Object> infoTypes = this.infoTypesList;
                if (features != null && !features.isEmpty()) {
                    infoTypes = features.stream().map(type -> InfoType.newBuilder().setName(type).build()).collect(Collectors.toList());
                }
                if ((bytes = ByteString.readFrom((InputStream)blob.getStream())).size() == 0) {
                    ScanResult scanResult = new ScanResult(Collections.emptyList());
                    return scanResult;
                }
                ByteContentItem byteContentItem = ByteContentItem.newBuilder().setType(bytesType).setData(bytes).build();
                ContentItem contentItem = ContentItem.newBuilder().setByteItem(byteContentItem).build();
                InspectConfig.FindingLimits findingLimits = InspectConfig.FindingLimits.newBuilder().setMaxFindingsPerRequest(maxResults != null ? maxResults : this.maxFindings).build();
                InspectConfig inspectConfig = InspectConfig.newBuilder().addAllInfoTypes(infoTypes).addAllCustomInfoTypes(this.customInfoTypesList).setMinLikelihood(this.likelihood).setLimits(findingLimits).setIncludeQuote(this.includeQuote).build();
                InspectContentRequest request = InspectContentRequest.newBuilder().setParent(ProjectName.of((String)this.projectId).toString()).setInspectConfig(inspectConfig).setItem(contentItem).build();
                InspectContentResponse response = dlpServiceClient.inspectContent(request);
                InspectResult result = response.getResult();
                if (result.getFindingsCount() > 0) {
                    for (Finding finding : result.getFindingsList()) {
                        String quote = null;
                        if (this.includeQuote) {
                            quote = finding.getQuote();
                        }
                        String type2 = finding.getInfoType().getName();
                        Likelihood score = finding.getLikelihood();
                        boolean sensitive = score.ordinal() >= this.sensitivity.ordinal();
                        Location location = finding.getLocation();
                        JSONObject locationJson = new JSONObject();
                        locationJson.put("hasByteRange", location.hasByteRange());
                        locationJson.put("hasCodepointRange", location.hasCodepointRange());
                        int contentLocationCount = location.getContentLocationsCount();
                        JSONArray locations = new JSONArray();
                        boolean firstImageLocHandled = false;
                        for (int iLoc = 0; iLoc < contentLocationCount; ++iLoc) {
                            ImageLocation imageLocation;
                            ContentLocation contentLocation = location.getContentLocations(iLoc);
                            if (!contentLocation.hasImageLocation() || (imageLocation = contentLocation.getImageLocation()).getBoundingBoxesCount() <= 0) continue;
                            JSONObject oneLoc = new JSONObject();
                            BoundingBox bb = imageLocation.getBoundingBoxes(0);
                            oneLoc.put("top", bb.getTop());
                            oneLoc.put("left", bb.getLeft());
                            oneLoc.put("width", bb.getWidth());
                            oneLoc.put("height", bb.getHeight());
                            locations.put((Object)oneLoc);
                            if (firstImageLocHandled) continue;
                            locationJson.put("firstImageLocation", (Object)oneLoc);
                            firstImageLocHandled = true;
                        }
                        locationJson.put("imageLocations", (Object)locations);
                        locationJson.put("hasImageLocation", locations.length() > 0);
                        if (location.hasByteRange()) {
                            JSONObject byteRange = new JSONObject();
                            byteRange.put("start", location.getByteRange().getStart());
                            byteRange.put("end", location.getByteRange().getEnd());
                            locationJson.put("byteRange", (Object)byteRange);
                        }
                        if (location.hasCodepointRange()) {
                            JSONObject codePointRange = new JSONObject();
                            codePointRange.put("start", location.getCodepointRange().getStart());
                            codePointRange.put("end", location.getCodepointRange().getEnd());
                            locationJson.put("codePointRange", (Object)codePointRange);
                        }
                        findings.add(new ScanFinding(sensitive, score.toString(), type2, quote, locationJson.toString()));
                    }
                }
                ScanResult scanResult = new ScanResult(findings);
                return scanResult;
            }
            finally {
                if (dlpServiceClient != null) {
                    try {
                        dlpServiceClient.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error calling Google Data Loss Prevention Service", (Throwable)e);
            return ScanResult.makeFailed();
        }
    }

    @Override
    public Blob redactBlob(Blob blob, List<String> features) {
        if (!this.enabled) {
            throw new NuxeoException("Renditions are disabled");
        }
        return this.renditionProvider.redact(blob, features);
    }

    @Override
    public Blob redactDocument(DocumentModel doc, List<String> features) {
        if (!this.enabled) {
            throw new NuxeoException("Renditions are disabled");
        }
        return this.renditionProvider.redact(doc, features);
    }

    @Override
    public List<Blob> redact(List<Blob> blobs, List<String> features) {
        return blobs.stream().map(b -> this.performRedaction((Blob)b, features)).collect(Collectors.toList());
    }

    protected Blob performRedaction(Blob blob, List<String> features) {
        Blob blob2;
        block22: {
            DlpServiceClient dlp = DlpServiceClient.create();
            try {
                ProjectName project = ProjectName.of((String)this.projectId);
                String mimeType = blob.getMimeType();
                if (mimeType == null) {
                    mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(blob.getFile());
                }
                ByteContentItem.BytesType bytesType = switch (mimeType) {
                    case "image/jpeg" -> ByteContentItem.BytesType.IMAGE_JPEG;
                    case "image/bmp" -> ByteContentItem.BytesType.IMAGE_BMP;
                    case "image/png" -> ByteContentItem.BytesType.IMAGE_PNG;
                    case "image/svg" -> ByteContentItem.BytesType.IMAGE_SVG;
                    default -> ByteContentItem.BytesType.BYTES_TYPE_UNSPECIFIED;
                };
                ByteString fileBytes = ByteString.readFrom((InputStream)blob.getStream());
                ByteContentItem byteItem = ByteContentItem.newBuilder().setType(bytesType).setData(fileBytes).build();
                List<Object> infoTypes = this.infoTypesList;
                if (features != null && !features.isEmpty()) {
                    infoTypes = features.stream().map(type -> InfoType.newBuilder().setName(type).build()).collect(Collectors.toList());
                }
                InspectConfig config = InspectConfig.newBuilder().addAllInfoTypes(infoTypes).addAllCustomInfoTypes(this.customInfoTypesList).setMinLikelihood(this.likelihood).build();
                RedactImageRequest request = RedactImageRequest.newBuilder().setParent(project.toString()).setByteItem(byteItem).setInspectConfig(config).build();
                RedactImageResponse response = dlp.redactImage(request);
                Blob redacted = Blobs.createBlob((InputStream)response.getRedactedImage().newInput());
                redacted.setFilename("redacted.png");
                redacted.setMimeType("image/png");
                blob2 = redacted;
                if (dlp == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (dlp != null) {
                        try {
                            dlp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new NuxeoException("Unable to redact image", (Throwable)e);
                }
            }
            dlp.close();
        }
        return blob2;
    }

    protected void createInspectTemplate(String displayName, String templateId, String description) {
        try (DlpServiceClient dlpClient = DlpServiceClient.create();){
            String project = ProjectName.of((String)this.projectId).toString();
            InspectConfig.FindingLimits findingLimits = InspectConfig.FindingLimits.newBuilder().setMaxFindingsPerRequest(this.maxFindings).build();
            InspectConfig config = InspectConfig.newBuilder().addAllInfoTypes(this.infoTypesList).setMinLikelihood(this.likelihood).setLimits(findingLimits).build();
            InspectTemplate template = InspectTemplate.newBuilder().setInspectConfig(config).setDisplayName(displayName).setDescription(description).build();
            CreateInspectTemplateRequest request = CreateInspectTemplateRequest.newBuilder().setParent(project).setInspectTemplate(template).setTemplateId(templateId).build();
            InspectTemplate response = dlpClient.createInspectTemplate(request);
            log.info("Template created: " + response.getName());
        }
        catch (Exception e) {
            log.error("Error creating template", (Throwable)e);
        }
    }

    public List<InfoTypeDescription> getInfoTypes(String filter, String languageCode) throws IOException {
        try (DlpServiceClient dlpClient = DlpServiceClient.create();){
            ListInfoTypesRequest.Builder builder = ListInfoTypesRequest.newBuilder();
            if (filter != null) {
                builder.setFilter(filter);
            }
            if (languageCode != null) {
                builder.setLanguageCode(languageCode);
            }
            ListInfoTypesRequest request = builder.build();
            ListInfoTypesResponse infoTypesResponse = dlpClient.listInfoTypes(request);
            List list = infoTypesResponse.getInfoTypesList();
            return list;
        }
    }
}

