/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.operations;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.platform.scanner.dlp.DataLossPreventionScanner;
import org.nuxeo.platform.scanner.dlp.service.ScanFinding;
import org.nuxeo.platform.scanner.dlp.service.ScanResult;

@Operation(id="Blob.IdentifySensitiveData", category="Files", label="Identify Sensitive Data", description="Identify sensitive data within a piece of content.")
public class IdentifySensitiveDataOperation {
    public static final String ID = "Blob.IdentifySensitiveData";
    @Context
    protected CoreSession session;
    @Context
    protected DataLossPreventionScanner service;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath;
    @Param(name="infotypes", required=false)
    protected StringList infoTypes;
    @Param(name="maxfindings", required=false)
    protected Integer maxFindings;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws IOException {
        Object bh = null;
        bh = StringUtils.isNotBlank((CharSequence)this.xpath) ? new DocumentBlobHolder(doc, this.xpath) : (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (!doc.hasFacet("DataLossPrevention")) {
            doc.addFacet("DataLossPrevention");
        }
        ScanResult res = this.runWorker((BlobHolder)bh);
        Property findingProp = doc.getProperty("dlp:findings");
        boolean failed = res.isError();
        boolean sensitive = res.hasSensitiveData();
        if (res.getFindings() != null) {
            findingProp.remove();
            for (ScanFinding f : res.getFindings()) {
                HashMap<String, String> fmap = new HashMap<String, String>();
                fmap.put("info", f.getInfo());
                fmap.put("score", f.getScore());
                fmap.put("type", f.getType());
                fmap.put("locationJson", f.getLocationJsonStr());
                findingProp.addValue(fmap);
            }
        }
        doc.setPropertyValue("dlp:sensitiveData", (Serializable)Boolean.valueOf(sensitive));
        doc.setPropertyValue("dlp:scanDate", (Serializable)new Date());
        doc.setPropertyValue("dlp:scanStatus", (Serializable)((Object)(failed ? "failed" : "done")));
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }

    @OperationMethod
    public Blob run(Blob blob) throws IOException {
        ScanResult result = this.runWorker((BlobHolder)new SimpleBlobHolder(blob));
        return Blobs.createJSONBlobFromValue((Object)result);
    }

    protected ScanResult runWorker(BlobHolder bh) throws IOException {
        return this.service.identify(bh.getBlob(), (List<String>)this.infoTypes, this.maxFindings);
    }
}

