/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.service;

import java.util.List;
import org.nuxeo.platform.scanner.dlp.service.ScanFinding;

public class ScanResult {
    protected final boolean sensitiveData;
    protected final List<ScanFinding> findings;
    protected final boolean error;

    public ScanResult(List<ScanFinding> findings) {
        this.sensitiveData = findings.stream().anyMatch(f -> f.hasSensitiveData());
        this.findings = findings;
        this.error = false;
    }

    private ScanResult() {
        this.sensitiveData = false;
        this.findings = null;
        this.error = true;
    }

    public static ScanResult makeFailed() {
        return new ScanResult();
    }

    public boolean hasSensitiveData() {
        return this.sensitiveData;
    }

    public List<ScanFinding> getFindings() {
        return this.findings;
    }

    public boolean isError() {
        return this.error;
    }
}

