/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.Annotation;
import org.nuxeo.ecm.platform.comment.api.AnnotationImpl;
import org.nuxeo.ecm.platform.comment.api.AnnotationService;

@Operation(id="NEV.CreateDlpAnnotations", category="NEV", label="Create DLP NEV Redaction Annotations", description="Create NEV Redaction annotations based on the stored dlp info. annotationColor is an optionnal parameter. Value must be passed has hexacolor, like #rrggbb, including the #")
public class CreateNevRedactionAnnotations {
    public static final Logger log = LogManager.getLogger(CreateNevRedactionAnnotations.class);
    public static final String ID = "NEV.CreateDlpAnnotations";
    @Context
    protected CoreSession session;
    @Context
    protected AnnotationService annotationService;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="annotationColor", required=false, values={"#000000"})
    protected String annotationColor = "#000000";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws IOException {
        if (!doc.hasFacet("DataLossPrevention")) {
            log.warn("document {} {} doesn't have the DLP facet", (Object)doc.getId(), (Object)doc.getPathAsString());
            return doc;
        }
        boolean hasSensitiveData = (Boolean)doc.getPropertyValue("dlp:sensitiveData");
        if (!hasSensitiveData) {
            log.warn("document {} {} doesn't have any sensitive data", (Object)doc.getId(), (Object)doc.getPathAsString());
            return doc;
        }
        List sensitiveData = (List)((Object)doc.getPropertyValue("dlp:findings"));
        if (sensitiveData == null || sensitiveData.isEmpty()) {
            return doc;
        }
        ObjectMapper mapper = new ObjectMapper();
        for (Map item : sensitiveData) {
            JsonNode json;
            boolean hasLocation;
            String locationJson = (String)item.get("locationJson");
            if (StringUtils.isBlank((CharSequence)locationJson) || !(hasLocation = (json = mapper.readTree(locationJson)).get("hasImageLocation").asBoolean())) continue;
            int pageNumber = json.has("pageNumber") ? json.get("pageNumber").asInt() : 0;
            int pageHeight = json.get("pageHeight").asInt();
            JsonNode locations = json.get("imageLocations");
            locations.iterator().forEachRemaining(location -> {
                AnnotationImpl annotation = new AnnotationImpl();
                annotation.setParentId(doc.getId());
                annotation.setXpath(this.xpath);
                annotation = (AnnotationImpl)this.annotationService.createAnnotation(this.session, (Annotation)annotation);
                annotation.setOrigin("ARender");
                int top = location.get("top").asInt();
                int left = location.get("left").asInt();
                int width = location.get("width").asInt();
                int height = location.get("height").asInt();
                int[] bottomLeft = new int[]{left, pageHeight - (top + height)};
                int[] topRight = new int[]{left + width, pageHeight - top};
                if (StringUtils.isBlank((CharSequence)this.annotationColor)) {
                    this.annotationColor = "#000000";
                }
                String annotationText = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ns0:xfdf xmlns:ns0=\"http://ns.adobe.com/xfdf/\"><ns0:annots><ns0:redact color=\"%s\" flags=\"\" name=\"%s\" last-modifier=\"System\" page=\"%d\" rect=\"%d,%d,%d,%d\" title=\"%s\" creationdate=\"D:20240919020457+00'00'\" opacity=\"1.0\" interior-color=\"#000000\" overlay-text=\"(b)(2)\"/></ns0:annots></ns0:xfdf>", this.annotationColor, annotation.getId(), pageNumber, bottomLeft[0], bottomLeft[1], topRight[0], topRight[1], item.get("type"));
                annotation.setEntityId(annotation.getId());
                annotation.setEntity(annotationText);
                this.annotationService.updateAnnotation(this.session, annotation.getId(), (Annotation)annotation);
            });
        }
        return doc;
    }
}

